package com.cpi.framework.web.entity.admin;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.cpi.framework.dao.model.SortEntity;
import com.cpi.framework.dao.support.StatusEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
/**
 * 岗位表
 * @author zsy
 */
@Entity
@Table(name = "FW_STATION")
public class FwStation extends SortEntity{

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
    /** 组织机构*/
	private FwOrg orgId;
	/** 岗位编码*/
	private String stCode;
	/** 岗位名称*/
	private String stName;
	/** 状态*/
	private StatusEnum status;
	/** 用户*/
	private Set<FwUser> fwUsers = new HashSet<FwUser>();
	/** 权限*/
	private Set<FwPermissions> fwPermissions = new HashSet<FwPermissions>();
	
	@ManyToOne(fetch=FetchType.LAZY)
	@JsonIgnore
	public FwOrg getOrgId() {
		return orgId;
	}
	public void setOrgId(FwOrg orgId) {
		this.orgId = orgId;
	}
	@Column(name = "ST_CODE")
	public String getStCode() {
		return stCode;
	}
	public void setStCode(String stCode) {
		this.stCode = stCode;
	}
	@Column(name = "ST_NAME")
	public String getStName() {
		return stName;
	}
	public void setStName(String stName) {
		this.stName = stName;
	}
	
	@Enumerated(EnumType.STRING)
	@Column(nullable=false,length=1)
	public StatusEnum getStatus() {
		return status;
	}
	public void setStatus(StatusEnum status) {
		this.status = status;
	}
		
	@OneToMany(mappedBy="stId",fetch=FetchType.LAZY)
	@JsonIgnore
	public Set<FwUser> getFwUsers() {
		return fwUsers;
	}
	public void setFwUsers(Set<FwUser> fwUsers) {
		this.fwUsers = fwUsers;
	}
	
	@ManyToMany(fetch=FetchType.LAZY,cascade={CascadeType.PERSIST, CascadeType.MERGE,CascadeType.REMOVE})
	@JoinTable(name = "FW_STATION_PERMISSIONS", joinColumns = { @JoinColumn(name = "ST_ID") }, inverseJoinColumns = { @JoinColumn(name = "PERMISSION_ID") })
	@JsonIgnore
	public Set<FwPermissions> getFwPermissions() {
		return fwPermissions;
	}
	public void setFwPermissions(Set<FwPermissions> fwPermissions) {
		this.fwPermissions = fwPermissions;
	}
	/**增加权限*/
	public void addFwPermissions(FwPermissions fwPermissions){
		this.fwPermissions.add(fwPermissions);
	}
}
