package com.cpi.framework.web.entity.admin;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.cpi.framework.dao.model.SortEntity;
import com.cpi.framework.dao.support.StatusEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 角色表
 * @author BridgeBai
 */
@Entity
@Table(name = "FW_ROLES")
public class FwRoles extends SortEntity {
	private static final long serialVersionUID = 1L;
	
	/**角色类型*/
	public enum RoleEnum{
		/** 超级管理员*/
		superAdmin("超级管理员"){

			@Override
			public String toString() {
				// TODO Auto-generated method stub
				return "超级管理员";
			}
			
		},
		/** 管理员 */
		admin("管理员"){
			@Override
			public String toString() {
				// TODO Auto-generated method stub
				return "管理员";
			}
		},
		/** 普通用户 */
		user("普通用户"){
			@Override
			public String toString() {
				// TODO Auto-generated method stub
				return "普通用户";
			}
		};
		
		private String value;
		
		private RoleEnum(String value) {
			this.value = value;
		}
		
		public String getValue() {
			return this.value;
		}
	}
	
	/**组织 */
	private FwOrg orgId;
	/**角色名称 */
	private String roleName;
	/**状态 */
	private StatusEnum status;
	/**备注 */
	private String memo;
	/**角色类型 */
	private RoleEnum roleType;
	/**用户 */
	private Set<FwUser> fwUsers = new HashSet<FwUser>(); 
	/**权限 */
	private Set<FwPermissions> fwPermissions = new HashSet<FwPermissions>();


	@ManyToOne(fetch=FetchType.LAZY)
	@JsonIgnore
	public FwOrg getOrgId() {
		return orgId;
	}

	public void setOrgId(FwOrg orgId) {
		this.orgId = orgId;
	}

	public String getMemo() {
		return this.memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	@Column(name = "ROLE_NAME")
	public String getRoleName() {
		return this.roleName;
	}

	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}

	@Enumerated(EnumType.ORDINAL)
	@Column(name = "ROLE_TYPE",nullable=false)
	public RoleEnum getRoleType() {
		return this.roleType;
	}

	public void setRoleType(RoleEnum roleType) {
		this.roleType = roleType;
	}

	@Enumerated(EnumType.STRING)
	@Column(nullable=false,length=1)
	public StatusEnum getStatus() {
		return this.status;
	}

	public void setStatus(StatusEnum status) {
		this.status = status;
	}
    @ManyToMany(mappedBy="fwRoles",fetch=FetchType.LAZY)
    @JsonIgnore
    public Set<FwUser> getFwUsers() {
		return fwUsers;
	}

	public void setFwUsers(Set<FwUser> fwUsers) {
		this.fwUsers = fwUsers;
	}

	// 多对多定义
	@ManyToMany(fetch = FetchType.LAZY)
	@JoinTable(name = "FW_ROLE_PERMISSIONS", joinColumns = { @JoinColumn(name = "ROLE_ID") }, inverseJoinColumns = { @JoinColumn(name = "PERMISSION_ID") })
	// 集合按id排序
	@OrderBy("ID ASC")
	@JsonIgnore
	public Set<FwPermissions> getFwPermissions() {
		return fwPermissions;
	}

	public void setFwPermissions(Set<FwPermissions> fwPermissions) {
		this.fwPermissions = fwPermissions;
	}
	
	@Transient
	public String getOrgName() {
		return this.orgId.getOrgName();
	}
}