package com.cpi.framework.web.entity.admin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.cpi.framework.dao.model.SortEntity;
import com.cpi.framework.dao.support.StatusEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 权限表
 * 
 * @author zsy
 */
@Entity
@Table(name = "FW_PERMISSIONS")
public class FwPermissions extends SortEntity {
	private static final long serialVersionUID = 1L;
	/**权限编码 */
	private String permissionCode;
	/**权限名称 */
	private String permissionName;
	/**权限类型 */
	private String permissionType;
	/**状态 */
	private StatusEnum status;
	/**用户 */
	private Set<FwUser> fwUsers = new HashSet<FwUser>(); 
	/**角色 */
	private Set<FwRoles> fwRoles = new HashSet<FwRoles>();
	/**岗位 */
	private Set<FwStation> fwStations = new HashSet<FwStation>();
	
	private List<FwPermissions> childList = new ArrayList<FwPermissions>();
	
	@Column(name = "PERMISSION_CODE")
	public String getPermissionCode() {
		return this.permissionCode;
	}

	public void setPermissionCode(String permissionCode) {
		this.permissionCode = permissionCode;
	}

	@Column(name = "PERMISSION_NAME")
	public String getPermissionName() {
		return this.permissionName;
	}

	public void setPermissionName(String permissionName) {
		this.permissionName = permissionName;
	}
	
	@Column(name = "PERMISSION_TYPE")
	public String getPermissionType() {
		return permissionType;
	}

	public void setPermissionType(String permissionType) {
		this.permissionType = permissionType;
	}

	@Enumerated(EnumType.STRING)
	@Column(nullable=false,length=1)
	public StatusEnum getStatus() {
		return this.status;
	}

	public void setStatus(StatusEnum status) {
		this.status = status;
	}
	
	@JsonIgnore
	// 多对多定义
	@ManyToMany(mappedBy="fwPermissions", fetch = FetchType.LAZY)
	@OrderBy("orderNo asc")
	public Set<FwUser> getFwUsers() {
		return fwUsers;
	}

	public void setFwUsers(Set<FwUser> fwUsers) {
		this.fwUsers = fwUsers;
	}

	@JsonIgnore
	// 多对多定义
	@ManyToMany(mappedBy="fwPermissions", fetch = FetchType.LAZY)	
	@OrderBy("orderNo asc")
	public Set<FwRoles> getFwRoles() {
		return fwRoles;
	}

	public void setFwRoles(Set<FwRoles> fwRoles) {
		this.fwRoles = fwRoles;
	}

	@JsonIgnore
	// 多对多定义
	@ManyToMany(mappedBy="fwPermissions", fetch = FetchType.LAZY)
	@OrderBy("orderNo asc")
	public Set<FwStation> getFwStations() {
		return fwStations;
	}

	public void setFwStations(Set<FwStation> fwStations) {
		this.fwStations = fwStations;
	}
	
	@Transient
	public List<FwPermissions> getChildList() {
		return childList;
	}

	public void setChildList(List<FwPermissions> childList) {
		this.childList = childList;
	}
	
		
}