package com.cpi.framework.web.entity.admin;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Table;
import javax.validation.Valid;

import com.cpi.framework.dao.model.IdEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;


/**
 * The persistent class for the FW_PENDING_MESSAGE database table.
 * 
 */
@Entity
@Table(name="FW_PENDING_MESSAGE")
public class FwPendingMessage extends IdEntity {
	private static final long serialVersionUID = 1L;
	
	/**业务类型*/
	public enum busiType{
		/**项目立项 */
		project,
		/** 项目变更 */
		projectChange,
		/** 项目周报 */
		weekReport,
		/** 项目月报 */
		monthReport		
	}
	/** 消息标题*/
	private String msgTitle;
	/** 消息地址*/
	private String msgUrl;
	/** 消息业务类型*/
	private busiType busiType;
	/** 消息业务ID*/
	private Long businessId;
	/** 消息流程ID*/
	private Long processInstId;
	/** 消息发送人*/
	private Long sendId;		
	/** 消息是否已处理*/
	private boolean isdeal=false;
	
	/** 消息待办接收人员明细*/
	private List<FwPendingDetails> fwPendingDetails=new ArrayList<FwPendingDetails>();
	
	@Column(name="MSG_TITLE")
	public String getMsgTitle() {
		return this.msgTitle;
	}

	public void setMsgTitle(String msgTitle) {
		this.msgTitle = msgTitle;
	}


	@Column(name="MSG_URL")
	public String getMsgUrl() {
		return this.msgUrl;
	}

	public void setMsgUrl(String msgUrl) {
		this.msgUrl = msgUrl;
	}
	
	@Column(name="BUSI_TYPE")
	@Enumerated(EnumType.ORDINAL)
	public busiType getBusiType() {
		return busiType;
	}

	public void setBusiType(busiType busiType) {
		this.busiType = busiType;
	}
	
	@Column(name="BUSINESS_ID")
	public Long getBusinessId() {
		return businessId;
	}

	public void setBusinessId(Long businessId) {
		this.businessId = businessId;
	}
	
	@Column(name="PROCESS_INST_ID")
	public Long getProcessInstId() {
		return processInstId;
	}

	public void setProcessInstId(Long processInstId) {
		this.processInstId = processInstId;
	}

	@Column(name="SEND_ID")
	public Long getSendId() {
		return sendId;
	}

	public void setSendId(Long sendId) {
		this.sendId = sendId;
	}
	
	@Column(name="IS_DEAL")
	public boolean getIsdeal() {
		return isdeal;
	}

	public void setIsdeal(boolean isdeal) {
		this.isdeal = isdeal;
	}

	@JsonIgnore
	@Valid
	@ElementCollection(fetch=FetchType.LAZY)
	@CollectionTable(name = "FW_PENDING_DETAILS")
	public List<FwPendingDetails> getFwPendingDetails() {
		return fwPendingDetails;
	}

	public void setFwPendingDetails(List<FwPendingDetails> fwPendingDetails) {
		this.fwPendingDetails = fwPendingDetails;
	}

	public void addPendingDetails(FwPendingDetails fwPendingDetail){
		this.fwPendingDetails.add(fwPendingDetail);
	}
}