package com.cpi.framework.web.entity.admin;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

import com.cpi.framework.dao.model.SortEntity;
import com.cpi.framework.dao.support.StatusEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 组织机构(部门)表
 * @author BridgeBai
 */
@Entity
@Table(name = "FW_ORG")
public class FwOrg extends SortEntity {
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	
	/**组织机构类型*/
	public enum orgEnum{
		/** 单位*/
		company,
		/** 部门 */
		departments
		
	}
	/** 组织编码*/
	private String orgCode;
	/** 组织名称*/
	private String orgName;
	/** 上级组织 */
	private FwOrg pId;	
	/** 组织类型*/
	private orgEnum orgType;
	/** 状态*/
	private StatusEnum status;
	/**备注*/	
	private String memo;
	/** 下级组织 */
	private Set<FwOrg> children = new HashSet<FwOrg>();
	/** 用户*/
	private Set<FwUser> fwUsers = new HashSet<FwUser>();
	/** 角色*/
	private Set<FwRoles> fwRoles = new HashSet<FwRoles>();
	/** 岗位*/
	private Set<FwStation> fwStations = new HashSet<FwStation>();
	
	public FwOrg(){
		
	}
    public FwOrg(Long id){
		super.setId(id);
	}
	
	@Column(name = "ORG_CODE", unique = true, nullable = false, length = 32)
	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	@Column(name = "ORG_NAME", nullable = false, length = 128)
	public String getOrgName() {
		return this.orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}
	
	@Enumerated(EnumType.ORDINAL)
	@Column(name = "ORG_TYPE")
	public orgEnum getOrgType() {
		return this.orgType;
	}

	public void setOrgType(orgEnum orgType) {
		this.orgType = orgType;
	}

	@Enumerated(EnumType.STRING)
	@Column(name = "STATUS", nullable = false, length = 1)
	public StatusEnum getStatus() {
		return this.status;
	}

	public void setStatus(StatusEnum status) {
		this.status = status;
	}

	@Column(name = "MEMO", length = 256)
	public String getMemo() {
		return this.memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}
	
	@ManyToOne(fetch = FetchType.LAZY)
	@JsonIgnore
	public FwOrg getpId() {
		return pId;
	}

	public void setpId(FwOrg pId) {
		this.pId = pId;
	}
	
	@JsonIgnore
	@OneToMany(mappedBy = "pId", fetch = FetchType.LAZY)
	@OrderBy("orderNo asc")
	public Set<FwOrg> getChildren() {
		return children;
	}

	public void setChildren(Set<FwOrg> children) {
		this.children = children;
	}
		
	@JsonIgnore
	@OneToMany(mappedBy = "orgId",cascade={CascadeType.REMOVE}, fetch = FetchType.LAZY)
	@OrderBy("orderNo asc")
	public Set<FwUser> getFwUsers() {
		return fwUsers;
	}

	public void setFwUsers(Set<FwUser> fwUsers) {
		this.fwUsers = fwUsers;
	}
	
	@JsonIgnore
	@OneToMany(mappedBy = "orgId",cascade={CascadeType.REMOVE}, fetch = FetchType.LAZY)
	@OrderBy("orderNo asc")
	public Set<FwRoles> getFwRoles() {
		return fwRoles;
	}

	public void setFwRoles(Set<FwRoles> fwRoles) {
		this.fwRoles = fwRoles;
	}
	
	@JsonIgnore
	@OneToMany(mappedBy = "orgId",cascade={CascadeType.REMOVE}, fetch = FetchType.LAZY)
	@OrderBy("orderNo asc")
	public Set<FwStation> getFwStations() {
		return fwStations;
	}

	public void setFwStations(Set<FwStation> fwStations) {
		this.fwStations = fwStations;
	}
    
}