package com.cpi.framework.web.entity.admin;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

import com.cpi.framework.dao.model.SortEntity;
import com.cpi.framework.dao.support.StatusEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 菜单表
 * 
 * @author BridgeBai
 */
@Entity
@Table(name = "FW_MENU")
public class FwMenu extends SortEntity {
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	
	/**菜单类型*/
	public enum MenuEnum{
		/** 目录*/
		folder,
		/** 网页 */
		page
		
	}
	/**菜单业务类型*/
	public enum businessEnum{
		/** 管理模块*/
		manager,
		/** 业务模块 */
		business		
	}
	/**菜单名称*/
	private String menuName;
	/**父菜单*/
	private FwMenu parentId;
	/**菜单类型*/
	private MenuEnum menuType;
	/**业务类型*/
	private businessEnum businessType;
	/**菜单地址*/
	private String menuUrl;
	/**菜单图标*/
	private String menuIco;
	/**菜单权限*/
	private String permissons;
	/**菜单状态*/
	private StatusEnum isDisplay;	
	/** 下级菜单 */
	private Set<FwMenu> children = new HashSet<FwMenu>();
	
	@Column(name = "MENU_NAME", nullable = false)
	public String getMenuName() {
		return menuName;
	}

	public void setMenuName(String menuName) {
		this.menuName = menuName;
	}

	@ManyToOne(fetch=FetchType.LAZY)
	@JsonIgnore
	public FwMenu getParentId() {
		return parentId;
	}

	public void setParentId(FwMenu parentId) {
		this.parentId = parentId;
	}

	@Enumerated(EnumType.ORDINAL)
	@Column(name = "MENU_TYPE", nullable = false)
	public MenuEnum getMenuType() {
		return menuType;
	}

	public void setMenuType(MenuEnum menuType) {
		this.menuType = menuType;
	}
	
    @Enumerated(EnumType.ORDINAL)
	@Column(name = "BUSINESS_TYPE", nullable = false)
	public businessEnum getBusinessType() {
		return this.businessType;
	}

	public void setBusinessType(businessEnum businessType) {
		this.businessType = businessType;
	}

	@Column(name = "MENU_URL", length = 512)
	public String getMenuUrl() {
		return menuUrl;
	}

	public void setMenuUrl(String menuUrl) {
		this.menuUrl = menuUrl;
	}

	@Column(name = "MENU_ICO", length = 128)
	public String getMenuIco() {
		return menuIco;
	}

	public void setMenuIco(String menuIco) {
		this.menuIco = menuIco;
	}

	@Column(name = "PERMISSONS", nullable = false)
	public String getPermissons() {
		return this.permissons;
	}

	public void setPermissons(String permissons) {
		this.permissons = permissons;
	}

	@Enumerated(EnumType.STRING)
	@Column(name = "IS_DISPLAY", nullable = false,length=1)
	public StatusEnum getIsDisplay() {
		return this.isDisplay;
	}

	public void setIsDisplay(StatusEnum isDisplay) {
		this.isDisplay = isDisplay;
	}

	@JsonIgnore
	@OneToMany(mappedBy="parentId",fetch=FetchType.LAZY)
	@OrderBy("orderNo asc")
	public Set<FwMenu> getChildren() {
		return children;
	}

	public void setChildren(Set<FwMenu> children) {
		this.children = children;
	}

	
}