package com.cpi.framework.web.entity.admin;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

import com.cpi.framework.dao.model.IdEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 数据字典类型表
 * @author BridgeBai
 */
@Entity
@Table(name = "FW_DICTIONARY_TYPE")
public class FwDictionaryType extends IdEntity {
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	/** 数据字典类型编码*/
	private String dicTypeCode;
	/** 数据字典类型名称*/
	private String dicTypeName;
	/** 备注*/
	private String memo;
	/** 数据字典*/
	
	Set<FwDictionary> fwDictionarys=new HashSet<FwDictionary>();
	
	@Column(name = "DIC_TYPECODE")
	public String getDicTypeCode() {
		return dicTypeCode;
	}

	public void setDicTypeCode(String dicTypeCode) {
		this.dicTypeCode = dicTypeCode;
	}
	@Column(name = "DIC_TYPENAME")
	public String getDicTypeName() {
		return dicTypeName;
	}

	public void setDicTypeName(String dicTypeName) {
		this.dicTypeName = dicTypeName;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}
	
    @OneToMany(cascade={CascadeType.PERSIST,CascadeType.MERGE,CascadeType.REMOVE},mappedBy="dicTypeId",fetch=FetchType.LAZY)
    @OrderBy(value = "orderNo ASC")
    @JsonIgnore
	public Set<FwDictionary> getFwDictionarys() {
		return fwDictionarys;
	}

	public void setFwDictionarys(Set<FwDictionary> fwDictionarys) {
		this.fwDictionarys = fwDictionarys;
	}

	/**级联添加数据字典 */
	public void addFwDictionary(FwDictionary fwDictionary){
		fwDictionary.setDicTypeId(this);
		this.fwDictionarys.add(fwDictionary);
	}
	
}