package com.cpi.framework.web.dao.admin.impl;

import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;

import org.springframework.stereotype.Repository;

import com.cpi.framework.dao.jpa.impl.BaseDaoImpl;
import com.cpi.framework.web.dao.admin.IFwDictionaryTypeDao;
import com.cpi.framework.web.entity.admin.FwDictionaryType;

/**
 * 数据字典类型Dao接口实现
 * 
 * @author BridgeBai
 * 
 */
@Repository("FwDictionaryTypeDaoImpl")
public class FwDictionaryTypeDaoImpl extends BaseDaoImpl<FwDictionaryType, Long> implements IFwDictionaryTypeDao{
	
	@Override
	public FwDictionaryType findDictionarys(String dictTypeCode) {
		if (dictTypeCode != null) {			
			try {
				String jpql = "select fwDictionaryType from FwDictionaryType fwDictionaryType join fetch fwDictionaryType.fwDictionarys where lower(fwDictionaryType.dicTypeCode) = lower(:dictTypeCode)";
				FwDictionaryType fwDictionaryType= entityManager.createQuery(jpql, FwDictionaryType.class).setFlushMode(FlushModeType.COMMIT).setParameter("dictTypeCode", dictTypeCode).getSingleResult();
				return fwDictionaryType;
			} catch (NoResultException e) {
				return null;
			}
		}
		return null;
	}
	
}