package com.cpi.framework.web.controller;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cpi.framework.core.spring.SpringContextHolder;
import com.cpi.framework.modules.utils.CustomDateEditor;
import com.cpi.framework.modules.utils.CustomLongEditor;
import com.cpi.framework.web.common.ResponseData;
import com.cpi.framework.web.common.utils.AjaxUtil;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * 所有Controller的基类
 * @author bridgebai
 *
 */
public abstract class BaseController {

	public static final String EXCEPTION_MESSAGE = "EXCEPTION_MESSAGE";
	public static final String FLASH_MESSAGE="FLASH_MESSAGE";
	protected final Logger logger;
	protected final ObjectMapper mapper;
	
	
	public BaseController() {
		this.logger=LoggerFactory.getLogger(this.getClass());
		this.mapper = new ObjectMapper();
	}

	@InitBinder
	public void initBinder(WebDataBinder binder) {		
		binder.registerCustomEditor(Date.class, new CustomDateEditor(true));
		binder.registerCustomEditor(Long.class, new CustomLongEditor(true));
	}

	@ExceptionHandler
	public void handleException(Exception exception,
			HttpServletRequest request, HttpServletResponse response) throws Exception {
		logger.error(exception.getMessage(), exception);
		response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
		request.setAttribute(EXCEPTION_MESSAGE, exception);
		if (!AjaxUtil.isAjaxRequest(request)) {
			throw exception;
		} else {
			String errorMsg = exception.getMessage();
			errorMsg = StringUtils.isBlank(errorMsg)?"":errorMsg.replace("\r\n", "");
			StackTraceElement[] ste = exception.getStackTrace();
			StringBuffer detailmessage = new StringBuffer();
			for (int i = 0; i < ste.length; i++) {
				detailmessage.append(ste[i]).append("\\t");
			}
			Map<String,Object> map=new HashMap<String,Object>();
			map.put("inftype", 2);
			map.put("showdetial", "");
			map.put("clientCode", errorMsg);
			map.put("message", "操作失败!!!");
			map.put("detailmessage", detailmessage);
			map.put("callback", "");
			ResponseData data =ResponseData.error(null,map);
			/*data.setRequestURI(request.getRequestURI());
			data.setExecptionTrace(ExceptionUtils.getFullStackTrace(exception));*/
			try {
				String json = this.mapper.writeValueAsString(data);
				response.setContentType("text/html;charset=UTF-8");
				response.getWriter().write(json);
			} catch (Exception e) {
				logger.error(e.getMessage(), e);
			}
		}
	}
	/**
	 * 获取国际化消息
	 * @param code  代码
	 * @param args  参数
	 * @return 国际化消息
	 */
	protected String message(String code, Object... args) {
		return SpringContextHolder.getMessage(code, args);
	}
	/**
	 * 添加瞬时消息
	 * @param redirectAttributes  RedirectAttributes
	 * @param message   消息
	 */
	protected void addFlashMessage(RedirectAttributes redirectAttributes, ResponseData responseData) {
		if (redirectAttributes != null && responseData != null) {
			redirectAttributes.addFlashAttribute(FLASH_MESSAGE, responseData);
		}
	}
}
