package com.cpi.framework.web.common.mybatis.page;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 分页信息。
 */
public class Pager<T> implements Serializable
{
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -9067418025524889604L;
	/** 每页显示几条 */
	private int size = 15;
	/** 总条数 */
	private int total = 0;
	/** 当前页 */
	private int currentPage = 0;
	/** 总页数 */
	private int totalPage;
	/** 当前记录起始索引 */
	private int currentResult = 0;
	/** 存放结果集 */
	private List<T> result = new ArrayList<T>();
	/** 最终页面显示的底部翻页导航，详细见：getPageStr(); */
	private String pageStr;

	private static final String pageLable = "\u9875"; // 页
	private static final String firstPageLabel = "\u9996\u9875"; // 首页
	private static final String endPageLabel = "\u5C3E\u9875";
	private static final String prePageLabel = "\u4e0a\u4e00\u9875"; // 上一页
	private static final String nextPageLabel = "\u4e0b\u4e00\u9875"; // 下一页
	private static final String errorPageInfo = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u9875\u6570"; // 请输入正确的页数
	private static final String errorMaxPage = "\u8f93\u5165\u7684\u9875\u6570\u4e0d\u80fd\u5927\u4e8e\u603b\u9875\u6570\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165"; // 输入的页数不能大于总页数，请重新输入
	private static final String goToPageLabel = "\u8df3\u8f6c\u5230"; // 跳转到
	private static final String countLabel = "\u6761"; // 条
	private static final String allLabel = "\u5171";// 共

	public Pager()
	{

	}

	public Pager(int TOTAL, int CURRENTPAGE, int TOTALPAGE)
	{
		setTotal(TOTAL);
		setTotalPage(TOTALPAGE);
		setCurrentPage(CURRENTPAGE);
	}

	/**
	 * 获取结果集
	 */
	public List<T> getResult()
	{
		if (result == null)
		{
			return new ArrayList<T>();
		}
		return result;
	}

	public void setResult(List<T> result)
	{
		this.result = result;
	}

	/**
	 * 获取总页数
	 */
	public int getTotalPage()
	{
		if (total % size == 0)
		{
			totalPage=total / size;
		}else{
			totalPage = total / size + 1;
		}
		return totalPage;
	}

	/**
	 * 获取总条数
	 */
	public int getTotal()
	{
		return total;
	}

	public void setTotal(int total)
	{
		this.total = total;
	}

	public int getCurrentPage()
	{
		if (currentPage <= 0)
		{
			currentPage = 1;
		}
		if (currentPage > getTotalPage())
		{
			currentPage = getTotalPage();
		}
		return currentPage;
	}

	public void setCurrentPage(int currentPage)
	{
		this.currentPage = currentPage;
	}

	public int getSize()
	{
		return size;
	}

	public void setSize(int size)
	{
		if (size == 0)
		{
			size = 15;
		}
		this.size = size;
	}

	public int getCurrentResult()
	{
		currentResult = (getCurrentPage() - 1) * getSize();
		if (currentResult < 0)
		{
			currentResult = 0;
		}
		return currentResult;
	}

	public void setCurrentResult(int currentResult)
	{
		this.currentResult = currentResult;
	}

	public void setTotalPage(int totalPage)
	{
		this.totalPage = totalPage;
	}

	public String getPageStr()
	{
		if(total<=15){
			return "";
		}
		StringBuffer buffer = new StringBuffer();
		buffer.append("<ul class=\"fy\">");
		buffer.append("<li><input type=\"button\" onclick=\"var pageNoVal = $('#fyinput').val();if(pageNoVal >" + totalPage + " ){alert('" + errorMaxPage + "');}else if(pageNoVal == 0){alert('" + errorPageInfo
				+ "');} else {nextPage(pageNoVal);}\" class=\"fy_botton\" value=\"GO\"/></li>");
		buffer.append("<li><font>"
				+ goToPageLabel
				+ "</font><input value='"
				+ currentPage
				+ "' id='fyinput' type=\"text\" class=\"fy_text\" size=\"3\" maxlength=\"8\" type=\"text\" onkeydown=\"var e = event || window.event || arguments.callee.caller.arguments[0]; if(e && e.keyCode==13){var pageNoVal = $(this).val(); if(pageNoVal >"
				+ totalPage + " ){alert('" + errorMaxPage + "');}else if(pageNoVal == 0){alert('" + errorPageInfo
				+ "');} else {nextPage(pageNoVal);}}\" onkeyup=\"this.value=this.value.replace(/[^0-9]/g,'')\" onblur=\"this.value=this.value.replace(/[^0-9]/g,'')\" />" + pageLable + "</li>");
		// 尾页
		if (currentPage < totalPage)
		{
			buffer.append("<li><a href=\"javascript:void(0);\" onclick=\"nextPage(" + (totalPage) + ")\">" + endPageLabel + "</a></li>");
		}
		else
		{
			buffer.append("<li>" + endPageLabel + "</li>");
		}
		// 下一页
		if (currentPage + 1 <= totalPage)
		{
			buffer.append("<li><a href=\"javascript:void(0);\" onclick=\"nextPage(" + (currentPage + 1) + ")\">" + nextPageLabel + "</a></li>");
		}
		else
		{
			buffer.append("<li>" + nextPageLabel + "</li>");
		}
		// 上一页
		if (currentPage != 0 && currentPage != 1)
		{
			buffer.append("<li><a href=\"javascript:void(0);\" onclick=\"nextPage(" + (currentPage - 1) + ")\">" + prePageLabel + "</a></li>");
		}
		else
		{
			buffer.append("<li>" + prePageLabel + "</li>");
		}
		// 首页
		if (currentPage == 0 || currentPage == 1)
		{
			buffer.append("<li>" + firstPageLabel + "</li>");
		}
		else
		{
			buffer.append("<li><a href=\"javascript:void(0);\" onclick=\"nextPage(1)\">" + firstPageLabel + "</a></li>");
		}
		buffer.append("<li>" + currentPage + "/" + totalPage + pageLable + "</li><li>" + allLabel + total + countLabel + "</li>");
		buffer.append("<li><select onchange=\"$('#size').val(this.value);nextPage(" + currentPage + ")\">");
		for (int sa : new int[] { 15, 30, 50, 100 })
		{
			if (sa == size)
			{
				buffer.append("<option value='" + sa + "' selected='selected'>" + sa + "</option>");
			}
			else
			{
				buffer.append("<option value='" + sa + "' >" + sa + "</option>");
			}
		}
		buffer.append("<select></li>");
		buffer.append("</ul>");
		pageStr = buffer.toString();
		return pageStr;
	}
}
