package com.cpi.framework.web.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;

import com.cpi.framework.modules.security.shiro.Principal;

public class OnlineUserManager {	
	
	/** 保存当前在线用户列表 */
	private static ConcurrentHashMap<Long,Principal> onlineMaps = new ConcurrentHashMap<Long, Principal>();
	
	/**
	 * 用户列表是否为空
	 * @return
	 */
	public static boolean isEmpty(){
		   return onlineMaps.isEmpty();
	}
	/**
	 * 在线用户的信息
	 * 当前返回的对象只能被遍历查询操作,不应该直接改变对象集合中数据
	 * @return
	 */
	public static ConcurrentHashMap<Long,Principal> getOnlineUsers(){
		  return onlineMaps;
	}
	
	
	/**
	 * 在线用户列表更新用户信息
	 * @param loginUser
	 * @return
	 */
	public static void updateOnlineUser(Principal principal){
			onlineMaps.putIfAbsent(principal.getId(), principal);
	}
	/**
	 * 在线用户列表删除用户
	 * @param loginUser
	 * @return
	 */
	public static void delOnlineUser(Principal principal){
			onlineMaps.remove(principal.getId());
	}
	
	/**
	 * 获取当前empId的人员信息
	 * @param empId
	 * @return
	 */
	public static Principal getLoginUserById(Long id){
		   return onlineMaps.get(id);
	}
	
	/**
	 * 是否包含当前人员id为键值的数据
	 * @param empId
	 * @return
	 */
	public static boolean containsKey(Long id){
			return onlineMaps.containsKey(id);
	}
	
	/**
	 * 按部门获取在线用户信息
	 * @return
	 */
	public static Map<Long,List<Principal>> getonlineOrgUser(){
		Map<Long,List<Principal>> map=new HashMap<Long,List<Principal>>();
		for(Entry<Long,Principal> entry : OnlineUserManager.getOnlineUsers().entrySet()){
			Long deptId=entry.getValue().getDepartmentId();
			if(map.containsKey(deptId)){
				map.get(deptId).add(entry.getValue());
			}else{
				List<Principal> list=new ArrayList<Principal>();
				list.add(entry.getValue());
				map.put(deptId, list);
			}
		}	
		return map;
	}
}
