/*
 * Copyright 2013-2015 placg.com. All rights reserved.
 * Support: http://www.placg.com
 * License: http://www.placg.com/license
 */
package com.cpi.framework.modules.security.shiro;

import java.io.Serializable;

/**
 * 身份信息
 * 
 * @author Zaric
 * @version 3.0
 */
public class Principal implements Serializable {

	private static final long serialVersionUID = 5798882004228239559L;

	/** ID */
	private Long id;

	/** 用户账号 */
	private String loginName;
	/** 用户姓名 */
	private String userName;
	/** 用户登录所属部门ID */
    private Long departmentId;
	/** 用户登录单位ID */
    private Long companyId;
	/**
	 * @param id
	 *            ID
	 * @param username
	 *            用户名
	 */
	public Principal(Long id, String loginName,String userName,Long departmentId,Long companyId) {
		this.id = id;
		this.loginName = loginName;
		this.userName=userName;
		this.departmentId=departmentId;
		this.companyId=companyId;
	}
	
	/**
	 * 获取ID
	 * 
	 * @return ID
	 */
	public Long getId() {
		return id;
	}

	/**
	 * 设置ID
	 * 
	 * @param id
	 *            ID
	 */
	public void setId(Long id) {
		this.id = id;
	}

	/**
	 * 获取用户名
	 * 
	 * @return 用户名
	 */
	public String getLoginName() {
		return loginName;
	}

	/**
	 * 设置用户名
	 * 
	 * @param loginName
	 *            用户名
	 */
	public void setLoginName(String loginName) {
		this.loginName = loginName;
	}

	/**
	 * 获取用户姓名
	 * @return
	 */
	public String getUserName() {
		return userName;
	}
	/**
	 * 设置用户姓名
	 * @param userName
	 */
	public void setUserName(String userName) {
		this.userName = userName;
	}
	
	/**
	 * 获取用户所属部门ID
	 * @return
	 */
    public Long getDepartmentId() {
		return departmentId;
	}

	public void setDepartmentId(Long departmentId) {
		this.departmentId = departmentId;
	}

	/**
     * 获取登录单位ID
     * @return
     */
	public Long getCompanyId() {
		return companyId;
	}
    /**
     * 设置登录单位ID
     * @param companyId
     */
	public void setCompanyId(Long companyId) {
		this.companyId = companyId;
	}


	@Override
	public String toString() {
		return loginName;
	}

}