package com.cpi.framework.dao.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.cpi.framework.dao.support.Order.Direction;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Pagination<T> implements Serializable {
	
	private static final long serialVersionUID = 1L;
	/** 内容 */
	private final List<T> result = new ArrayList<T>();
	
	/** 其它以键值形式存在的内容 */
	private Map<String,Object> attMap=new HashMap<String, Object>();

	/** 总记录数 */
	private final long total;

	/** 分页信息 */
	private final Pageable pageable;

	/**
	 * 初始化一个新创建的Page对象
	 */
	public Pagination() {
		this.total = 0L;
		this.pageable = new Pageable();
	}

	/**
	 * @param content
	 *            内容
	 * @param total
	 *            总记录数
	 * @param pageable
	 *            分页信息
	 */
	public Pagination(List<T> content, long total, Pageable pageable) {
		this.result.addAll(content);
		this.total = total;
		this.pageable = pageable;
	}

	public Map<String, Object> getAttMap() {
		return attMap;
	}
	
	public void setAttMap(Map<String, Object> attMap) {
		this.attMap = attMap;
	}
	
	public void addAttMap(String key,String value) {
		this.attMap.put(key, value);
	}
	
	/**
	 * 获取页码
	 * 
	 * @return 页码
	 */
	@JsonIgnore
	public int getPageNumber() {
		return pageable.getPageNumber();
	}

	/**
	 * 获取每页记录数
	 * 
	 * @return 每页记录数
	 */
	@JsonIgnore
	public int getPageSize() {
		return pageable.getPageSize();
	}

	/**
	 * 获取搜索属性
	 * 
	 * @return 搜索属性
	 */
	@JsonIgnore
	public String getSearchProperty() {
		return pageable.getSearchProperty();
	}

	/**
	 * 获取搜索值
	 * 
	 * @return 搜索值
	 */
	@JsonIgnore
	public String getSearchValue() {
		return pageable.getSearchValue();
	}

	/**
	 * 获取排序属性
	 * 
	 * @return 排序属性
	 */
	@JsonIgnore
	public String getOrderProperty() {
		return pageable.getOrderProperty();
	}

	/**
	 * 获取排序方向
	 * 
	 * @return 排序方向
	 */
	@JsonIgnore
	public Direction getOrderDirection() {
		return pageable.getOrderDirection();
	}

	/**
	 * 获取排序
	 * 
	 * @return 排序
	 */
	@JsonIgnore
	public List<Order> getOrders() {
		return pageable.getOrders();
	}

	/**
	 * 获取筛选
	 * 
	 * @return 筛选
	 */
	@JsonIgnore
	public List<Filter> getFilters() {
		return pageable.getFilters();
	}

	/**
	 * 获取总页数
	 * 
	 * @return 总页数
	 */
	@JsonIgnore
	public int getTotalPages() {
		return (int) Math.ceil((double) getTotal() / (double) getPageSize());
	}

	/**
	 * 获取内容
	 * 
	 * @return 内容
	 */
	@JsonProperty("rows")
	public List<T> getResult() {
		return result;
	}

	/**
	 * 获取总记录数
	 * 
	 * @return 总记录数
	 */
	@JsonProperty("total")
	public long getTotal() {
		return total;
	}

	/**
	 * 获取分页信息
	 * 
	 * @return 分页信息
	 */
	@JsonIgnore
	public Pageable getPageable() {
		return pageable;
	}

}
