package com.cpi.framework.dao.model;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.Min;

import org.apache.commons.lang.builder.CompareToBuilder;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Entity - 排序基类
 * 
 */
@MappedSuperclass
public abstract class SortEntity extends IdEntity implements Comparable<SortEntity> {

	private static final long serialVersionUID = 5995013015967525827L;
	
	/** 访问路径前缀 */
	public static final String TREE_PATH_SEPARATOR = ",";

	/** "排序"属性名称 */
	public static final String ORDER_PROPERTY_NAME = "orderNo";

	/** 排序 */
	private Integer orderNo;

	/**
	 * 获取排序
	 * 
	 * @return 排序
	 */
	@JsonProperty
	@Min(0)
	@Column(name = "ORDER_NO")
	public Integer getOrderNo() {
		return orderNo;
	}

	/**
	 * 设置排序
	 * 
	 * @param order
	 *            排序
	 */
	public void setOrderNo(Integer orderNo) {
		this.orderNo = orderNo;
	}

	/**
	 * 实现compareTo方法
	 * 
	 * @param sortEntity
	 *            排序对象
	 * @return 比较结果
	 */
	public int compareTo(SortEntity sortEntity) {
		return new CompareToBuilder().append(getOrderNo(), sortEntity.getOrderNo()).append(getId(), sortEntity.getId()).toComparison();
	}

}