package com.cpi.framework.dao.key;

import java.io.Serializable;
import java.util.Properties;

import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.type.Type;

import com.cpi.framework.dao.utils.PrimaryKeyUtil;

public class SequenceGenerator
  implements IdentifierGenerator, Configurable
{
  private String tableName;

  public Serializable generate(SessionImplementor session, Object object)
    throws HibernateException
  {
    return getNext(session);
  }

  public void configure(Type type, Properties params, Dialect d)
    throws MappingException
  {
    this.tableName = params.getProperty("table");
    if (this.tableName == null)
      this.tableName = params.getProperty("target_table");
  }

  private Long getNext(SessionImplementor session) throws HibernateException {
    return PrimaryKeyUtil.getPrimaryKey(this.tableName);
  }
}