/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.eventing;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.ReactorOps;
import com.couchbase.client.java.manager.eventing.AsyncScopeEventingFunctionManager;
import com.couchbase.client.java.manager.eventing.DeployFunctionOptions;
import com.couchbase.client.java.manager.eventing.DropFunctionOptions;
import com.couchbase.client.java.manager.eventing.EventingFunction;
import com.couchbase.client.java.manager.eventing.EventingStatus;
import com.couchbase.client.java.manager.eventing.FunctionsStatusOptions;
import com.couchbase.client.java.manager.eventing.GetAllFunctionsOptions;
import com.couchbase.client.java.manager.eventing.GetFunctionOptions;
import com.couchbase.client.java.manager.eventing.PauseFunctionOptions;
import com.couchbase.client.java.manager.eventing.ResumeFunctionOptions;
import com.couchbase.client.java.manager.eventing.UndeployFunctionOptions;
import com.couchbase.client.java.manager.eventing.UpsertFunctionOptions;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Volatile
public class ReactiveScopeEventingFunctionManager {
    private final AsyncScopeEventingFunctionManager asyncManager;
    private final ReactorOps reactor;

    @Stability.Internal
    public ReactiveScopeEventingFunctionManager(ReactorOps reactor, AsyncScopeEventingFunctionManager asyncManager) {
        this.reactor = Objects.requireNonNull(reactor);
        this.asyncManager = Objects.requireNonNull(asyncManager);
    }

    public Mono<Void> upsertFunction(EventingFunction function) {
        return this.upsertFunction(function, UpsertFunctionOptions.upsertFunctionOptions());
    }

    public Mono<Void> upsertFunction(EventingFunction function, UpsertFunctionOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncManager.upsertFunction(function, options));
    }

    public Mono<EventingFunction> getFunction(String name) {
        return this.getFunction(name, GetFunctionOptions.getFunctionOptions());
    }

    public Mono<EventingFunction> getFunction(String name, GetFunctionOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncManager.getFunction(name, options));
    }

    public Flux<EventingFunction> getAllFunctions() {
        return this.getAllFunctions(GetAllFunctionsOptions.getAllFunctionsOptions());
    }

    public Flux<EventingFunction> getAllFunctions(GetAllFunctionsOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncManager.getAllFunctions(options)).flatMapMany(Flux::fromIterable);
    }

    public Mono<Void> dropFunction(String name) {
        return this.dropFunction(name, DropFunctionOptions.dropFunctionOptions());
    }

    public Mono<Void> dropFunction(String name, DropFunctionOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncManager.dropFunction(name, options));
    }

    public Mono<Void> deployFunction(String name) {
        return this.deployFunction(name, DeployFunctionOptions.deployFunctionOptions());
    }

    public Mono<Void> deployFunction(String name, DeployFunctionOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncManager.deployFunction(name, options));
    }

    public Mono<Void> undeployFunction(String name) {
        return this.undeployFunction(name, UndeployFunctionOptions.undeployFunctionOptions());
    }

    public Mono<Void> undeployFunction(String name, UndeployFunctionOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncManager.undeployFunction(name, options));
    }

    public Mono<Void> pauseFunction(String name) {
        return this.pauseFunction(name, PauseFunctionOptions.pauseFunctionOptions());
    }

    public Mono<Void> pauseFunction(String name, PauseFunctionOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncManager.pauseFunction(name, options));
    }

    public Mono<Void> resumeFunction(String name) {
        return this.resumeFunction(name, ResumeFunctionOptions.resumeFunctionOptions());
    }

    public Mono<Void> resumeFunction(String name, ResumeFunctionOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncManager.resumeFunction(name, options));
    }

    public Mono<EventingStatus> functionsStatus() {
        return this.functionsStatus(FunctionsStatusOptions.functionsStatusOptions());
    }

    public Mono<EventingStatus> functionsStatus(FunctionsStatusOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.asyncManager.functionsStatus(options));
    }
}

