/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio;

import com.corundumstudio.socketio.BroadcastAckCallback;
import com.corundumstudio.socketio.BroadcastOperations;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.misc.IterableCollection;
import com.corundumstudio.socketio.protocol.EngineIOVersion;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.protocol.PacketType;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.store.pubsub.DispatchMessage;
import com.corundumstudio.socketio.store.pubsub.PubSubType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public class SingleRoomBroadcastOperations
implements BroadcastOperations {
    private final String namespace;
    private final String room;
    private final Iterable<SocketIOClient> clients;
    private final StoreFactory storeFactory;

    public SingleRoomBroadcastOperations(String namespace, String room, Iterable<SocketIOClient> clients, StoreFactory storeFactory) {
        this.namespace = namespace;
        this.room = room;
        this.clients = clients;
        this.storeFactory = storeFactory;
    }

    private void dispatch(Packet packet) {
        this.storeFactory.pubSubStore().publish(PubSubType.DISPATCH, new DispatchMessage(this.room, packet, this.namespace));
    }

    @Override
    public Collection<SocketIOClient> getClients() {
        return new IterableCollection<SocketIOClient>(this.clients);
    }

    @Override
    public void send(Packet packet) {
        for (SocketIOClient client : this.clients) {
            packet.setEngineIOVersion(client.getEngineIOVersion());
            client.send(packet);
        }
        this.dispatch(packet);
    }

    @Override
    public <T> void send(Packet packet, BroadcastAckCallback<T> ackCallback) {
        for (SocketIOClient client : this.clients) {
            client.send(packet, ackCallback.createClientCallback(client));
        }
        ackCallback.loopFinished();
    }

    @Override
    public void disconnect() {
        for (SocketIOClient client : this.clients) {
            client.disconnect();
        }
    }

    @Override
    public void sendEvent(String name, SocketIOClient excludedClient, Object ... data) {
        Predicate<SocketIOClient> excludePredicate = socketIOClient -> Objects.equals(socketIOClient.getSessionId(), excludedClient.getSessionId());
        this.sendEvent(name, excludePredicate, data);
    }

    @Override
    public void sendEvent(String name, Predicate<SocketIOClient> excludePredicate, Object ... data) {
        Packet packet = new Packet(PacketType.MESSAGE, EngineIOVersion.UNKNOWN);
        packet.setSubType(PacketType.EVENT);
        packet.setName(name);
        packet.setData(Arrays.asList(data));
        for (SocketIOClient client : this.clients) {
            packet.setEngineIOVersion(client.getEngineIOVersion());
            if (excludePredicate.test(client)) continue;
            client.send(packet);
        }
        this.dispatch(packet);
    }

    @Override
    public void sendEvent(String name, Object ... data) {
        Packet packet = new Packet(PacketType.MESSAGE, EngineIOVersion.UNKNOWN);
        packet.setSubType(PacketType.EVENT);
        packet.setName(name);
        packet.setData(Arrays.asList(data));
        this.send(packet);
    }

    @Override
    public <T> void sendEvent(String name, Object data, BroadcastAckCallback<T> ackCallback) {
        for (SocketIOClient client : this.clients) {
            client.sendEvent(name, ackCallback.createClientCallback(client), data);
        }
        ackCallback.loopFinished();
    }

    @Override
    public <T> void sendEvent(String name, Object data, SocketIOClient excludedClient, BroadcastAckCallback<T> ackCallback) {
        Predicate<SocketIOClient> excludePredicate = socketIOClient -> Objects.equals(socketIOClient.getSessionId(), excludedClient.getSessionId());
        this.sendEvent(name, data, excludePredicate, ackCallback);
    }

    @Override
    public <T> void sendEvent(String name, Object data, Predicate<SocketIOClient> excludePredicate, BroadcastAckCallback<T> ackCallback) {
        for (SocketIOClient client : this.clients) {
            if (excludePredicate.test(client)) continue;
            client.sendEvent(name, ackCallback.createClientCallback(client), data);
        }
        ackCallback.loopFinished();
    }
}

