/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseSslContextProvider;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import com.clickhouse.client.http.ClickHouseHttpResponse;
import com.clickhouse.client.http.ClickHouseResponseHandler;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseDataStreamFactory;
import com.clickhouse.data.ClickHouseExternalTable;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePipedOutputStream;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;

public class HttpClientConnectionImpl
extends ClickHouseHttpConnection {
    private static final Logger log = LoggerFactory.getLogger(HttpClientConnectionImpl.class);
    private static final String USER_AGENT = ClickHouseClientOption.buildUserAgent(null, "HttpClient");
    private final AtomicBoolean busy;
    private final HttpClient httpClient;
    private final HttpRequest pingRequest;

    private ClickHouseHttpResponse buildResponse(ClickHouseConfig config, HttpResponse<InputStream> r, ClickHouseOutputStream output, Runnable postAction) throws IOException {
        Runnable action;
        InputStream source;
        boolean hasCustomOutput;
        HttpHeaders headers = r.headers();
        String displayName = headers.firstValue("X-ClickHouse-Server-Display-Name").orElse(this.server.getHost());
        String queryId = headers.firstValue("X-ClickHouse-Query-Id").orElse("");
        String summary = headers.firstValue("X-ClickHouse-Summary").orElse("{}");
        ClickHouseFormat format = config.getFormat();
        TimeZone timeZone = config.getServerTimeZone();
        if (!ClickHouseChecker.isNullOrEmpty(queryId)) {
            String value = headers.firstValue("X-ClickHouse-Format").orElse("");
            format = !ClickHouseChecker.isNullOrEmpty(value) ? ClickHouseFormat.valueOf(value) : format;
            value = headers.firstValue("X-ClickHouse-Timezone").orElse("");
            timeZone = !ClickHouseChecker.isNullOrEmpty(value) ? TimeZone.getTimeZone(value) : timeZone;
        }
        boolean bl = hasCustomOutput = output != null && output.getUnderlyingStream().hasOutput();
        if (output != null) {
            source = ClickHouseInputStream.empty();
            action = () -> {
                try (ClickHouseOutputStream o = output;){
                    ClickHouseInputStream.pipe(this.checkResponse(config, r).body(), (OutputStream)o, config.getWriteBufferSize());
                    if (postAction != null) {
                        postAction.run();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to redirect response to given output stream", e);
                }
                finally {
                    this.closeQuietly();
                }
            };
        } else {
            source = this.checkResponse(config, r).body();
            action = () -> {
                if (postAction != null) {
                    postAction.run();
                }
                this.closeQuietly();
            };
        }
        return new ClickHouseHttpResponse(this, hasCustomOutput ? ClickHouseInputStream.of(source, config.getReadBufferSize(), action) : ClickHouseInputStream.wrap(null, source, config.getReadBufferSize(), config.getResponseCompressAlgorithm(), config.getResponseCompressLevel(), action), displayName, queryId, summary, format, timeZone);
    }

    private HttpResponse<InputStream> checkResponse(ClickHouseConfig config, HttpResponse<InputStream> r) throws IOException {
        if (r.statusCode() != 200) {
            String errorMsg;
            String errorCode = r.headers().firstValue("X-ClickHouse-Exception-Code").orElse("");
            String serverName = r.headers().firstValue("X-ClickHouse-Server-Display-Name").orElse("");
            int bufferSize = (Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue();
            ByteArrayOutputStream output = new ByteArrayOutputStream(bufferSize);
            ClickHouseInputStream.pipe(r.body(), (OutputStream)output, bufferSize);
            byte[] bytes = output.toByteArray();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)ClickHouseClient.getResponseInputStream(config, new ByteArrayInputStream(bytes), this::closeQuietly), StandardCharsets.UTF_8));){
                StringBuilder builder = new StringBuilder();
                while ((errorMsg = reader.readLine()) != null) {
                    builder.append(errorMsg).append('\n');
                }
                errorMsg = builder.toString();
            }
            catch (IOException e) {
                errorMsg = HttpClientConnectionImpl.parseErrorFromException(errorCode, serverName, e, bytes);
            }
            throw new IOException(errorMsg);
        }
        return r;
    }

    private HttpRequest newRequest(String url) {
        return HttpRequest.newBuilder().uri(URI.create(url)).version(HttpClient.Version.HTTP_1_1).timeout(Duration.ofMillis(this.config.getSocketTimeout())).build();
    }

    protected HttpClientConnectionImpl(ClickHouseNode server, ClickHouseRequest<?> request, ExecutorService executor) throws IOException {
        super(server, request);
        HttpClient.Builder builder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofMillis(this.config.getConnectionTimeout())).followRedirects(HttpClient.Redirect.NORMAL);
        if (executor != null) {
            builder.executor(executor);
        }
        if (this.config.isUseNoProxy()) {
            builder.proxy(NoProxySelector.INSTANCE);
        }
        if (this.config.isSsl()) {
            builder.sslContext(ClickHouseSslContextProvider.getProvider().getSslContext(SSLContext.class, this.config).orElse(null));
        }
        this.busy = new AtomicBoolean(false);
        this.httpClient = builder.build();
        this.pingRequest = this.newRequest(this.getBaseUrl() + "ping");
    }

    @Override
    protected boolean isReusable() {
        return this.busy.get();
    }

    private CompletableFuture<HttpResponse<InputStream>> postRequest(HttpRequest request) {
        return this.httpClient.sendAsync(request, responseInfo -> new ClickHouseResponseHandler(this.config.getMaxQueuedBuffers(), this.config.getSocketTimeout()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClickHouseHttpResponse postStream(ClickHouseConfig config, HttpRequest.Builder reqBuilder, byte[] boundary, String sql, ClickHouseInputStream data, List<ClickHouseExternalTable> tables, ClickHouseOutputStream output, Runnable postAction) throws IOException {
        try {
            HttpResponse<InputStream> r;
            ClickHousePipedOutputStream stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(config);
            reqBuilder.POST(HttpRequest.BodyPublishers.ofInputStream(stream::getInputStream));
            CompletableFuture<HttpResponse<InputStream>> f = this.postRequest(reqBuilder.build());
            HttpClientConnectionImpl.postData(config, boundary, sql, data, tables, stream);
            try {
                r = f.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread was interrupted when posting request or receiving response", e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof HttpConnectTimeoutException) {
                    throw new ConnectException(cause.getMessage());
                }
                throw new IOException("Failed to post request", cause);
            }
            ClickHouseHttpResponse clickHouseHttpResponse = this.buildResponse(config, r, output, postAction);
            return clickHouseHttpResponse;
        }
        finally {
            this.busy.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClickHouseHttpResponse postString(ClickHouseConfig config, HttpRequest.Builder reqBuilder, String sql, ClickHouseOutputStream output, Runnable postAction) throws IOException {
        try {
            HttpResponse<InputStream> r;
            reqBuilder.POST(HttpRequest.BodyPublishers.ofString(sql));
            try {
                r = this.postRequest(reqBuilder.build()).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread was interrupted when posting request or receiving response", e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof HttpConnectTimeoutException) {
                    throw new ConnectException(cause.getMessage());
                }
                throw new IOException("Failed to post query", cause);
            }
            ClickHouseHttpResponse clickHouseHttpResponse = this.buildResponse(config, r, output, postAction);
            return clickHouseHttpResponse;
        }
        finally {
            this.busy.set(false);
        }
    }

    @Override
    protected final String getDefaultUserAgent() {
        return USER_AGENT;
    }

    @Override
    protected ClickHouseHttpResponse post(ClickHouseConfig config, String sql, ClickHouseInputStream data, List<ClickHouseExternalTable> tables, ClickHouseOutputStream output, String url, Map<String, String> headers, Runnable postAction) throws IOException {
        if (!this.busy.compareAndSet(false, true)) {
            throw new ConnectException("Connection is busy");
        }
        ClickHouseConfig c = config == null ? this.config : config;
        HttpRequest.Builder reqBuilder = HttpRequest.newBuilder().uri(URI.create(ClickHouseChecker.isNullOrEmpty(url) ? this.url : url)).timeout(Duration.ofMillis(c.getSocketTimeout()));
        byte[] boundary = null;
        if (tables != null && !tables.isEmpty()) {
            String uuid = this.rm.createUniqueId();
            reqBuilder.setHeader("content-type", "multipart/form-data; boundary=" + uuid);
            boundary = uuid.getBytes(StandardCharsets.US_ASCII);
        } else {
            reqBuilder.setHeader("content-type", "text/plain; charset=UTF-8");
        }
        headers = this.mergeHeaders(headers);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                reqBuilder.setHeader(header.getKey(), header.getValue());
            }
        }
        return boundary != null || data != null || c.isRequestCompressed() ? this.postStream(c, reqBuilder, boundary, sql, data, tables, output, postAction) : this.postString(c, reqBuilder, sql, output, postAction);
    }

    @Override
    public boolean ping(int timeout) {
        String response = this.config.getStrOption(ClickHouseHttpOption.DEFAULT_RESPONSE);
        try {
            HttpResponse<String> r = this.httpClient.send(this.pingRequest, HttpResponse.BodyHandlers.ofString());
            return r.statusCode() == 200 && response.equals(r.body());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            log.debug((Object)"Failed to ping server: %s", e.getMessage());
        }
        return false;
    }

    @Override
    public void close() {
    }

    static class NoProxySelector
    extends ProxySelector {
        static final NoProxySelector INSTANCE = new NoProxySelector();
        private static final List<Proxy> NO_PROXY_LIST = List.of(Proxy.NO_PROXY);

        private NoProxySelector() {
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException e) {
        }

        @Override
        public List<Proxy> select(URI uri) {
            return NO_PROXY_LIST;
        }
    }
}

