/*
 * Decompiled with CFR 0.152.
 */
package com.blade.patchca;

import com.blade.mvc.WebContext;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.mvc.http.Session;
import com.blade.patchca.Patchca;
import com.blade.patchca.PatchcaException;
import com.blade.server.netty.HttpConst;
import com.blade.server.netty.ProgressiveFutureListener;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.concurrent.GenericFutureListener;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import org.patchca.color.ColorFactory;
import org.patchca.filter.FilterFactory;
import org.patchca.filter.predefined.DiffuseRippleFilterFactory;
import org.patchca.service.ConfigurableCaptchaService;
import org.patchca.utils.encoder.EncoderHelper;
import org.patchca.word.RandomWordFactory;
import org.patchca.word.WordFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPatchca
implements Patchca {
    private static final Logger log = LoggerFactory.getLogger(DefaultPatchca.class);
    private static final String DEFAULT_SESSION_KEY = "patchca_code";
    private static Random random = new Random();
    private ConfigurableCaptchaService cs = new ConfigurableCaptchaService();
    private RandomWordFactory wf;

    public DefaultPatchca() {
        this(x -> {
            int[] c = new int[3];
            int i = random.nextInt(c.length);
            for (int fi = 0; fi < c.length; ++fi) {
                c[fi] = fi == i ? random.nextInt(71) : random.nextInt(256);
            }
            return new Color(c[0], c[1], c[2]);
        });
    }

    public DefaultPatchca(ColorFactory colorFactory) {
        this.cs.setColorFactory(colorFactory);
        this.wf = new RandomWordFactory();
        this.wf.setCharacters("23456789abcdefghigkmnpqrstuvwxyzABCDEFGHIGKLMNPQRSTUVWXYZ");
        this.wf.setMinLength(4);
        this.wf.setMaxLength(6);
        this.cs.setWordFactory(this.wf);
        this.cs.setFilterFactory(new DiffuseRippleFilterFactory());
    }

    @Override
    public Patchca length(int lenth) {
        this.wf.setMaxLength(lenth);
        this.wf.setMinLength(lenth);
        this.cs.setWordFactory(this.wf);
        return this;
    }

    @Override
    public Patchca length(int min, int max) {
        this.wf.setMinLength(min);
        this.wf.setMaxLength(max);
        this.cs.setWordFactory(this.wf);
        return this;
    }

    @Override
    public Patchca size(int width, int height) {
        this.cs.setWidth(width);
        this.cs.setHeight(height);
        return this;
    }

    @Override
    public Patchca color(ColorFactory colorFactory) {
        this.cs.setColorFactory(colorFactory);
        return this;
    }

    @Override
    public Patchca word(WordFactory wordFactory) {
        this.cs.setWordFactory(wordFactory);
        return this;
    }

    @Override
    public Patchca filter(FilterFactory filterFactory) {
        this.cs.setFilterFactory(filterFactory);
        return this;
    }

    @Override
    public String render() throws PatchcaException {
        return this.render(DEFAULT_SESSION_KEY);
    }

    @Override
    public String render(String sessionKey) throws PatchcaException {
        try {
            Session session = WebContext.request().session();
            Request request = WebContext.request();
            ChannelHandlerContext ctx = WebContext.get().getChannelHandlerContext();
            File file = File.createTempFile("blade_code_", ".png");
            FileOutputStream fos = new FileOutputStream(file);
            String token = EncoderHelper.getChallangeAndWriteImage(this.cs, "png", fos);
            session.attribute(sessionKey, (Object)token);
            log.debug("current sessionid = [{}], token = [{}]", (Object)session.id(), (Object)token);
            DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            this.setResponseHeaders(WebContext.response());
            RandomAccessFile raf = null;
            try {
                ChannelFuture lastContentFuture;
                ChannelFuture sendFileFuture;
                raf = new RandomAccessFile(file, "r");
                long fileLength = raf.length();
                httpResponse.headers().set(HttpConst.CONTENT_LENGTH, (Object)fileLength);
                if (request.keepAlive()) {
                    httpResponse.headers().set(HttpConst.CONNECTION, (Object)HttpConst.KEEP_ALIVE);
                }
                ctx.write((Object)httpResponse);
                if (ctx.pipeline().get(SslHandler.class) == null) {
                    sendFileFuture = ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
                    lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                } else {
                    lastContentFuture = sendFileFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise());
                }
                sendFileFuture.addListener((GenericFutureListener)ProgressiveFutureListener.build((RandomAccessFile)raf));
                if (!request.keepAlive()) {
                    lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
            }
            catch (FileNotFoundException e) {
                throw new PatchcaException(e);
            }
            return token;
        }
        catch (IOException e) {
            throw new PatchcaException(e);
        }
    }

    private void setResponseHeaders(Response response) {
        response.contentType("image/png");
        response.header("Cache-Control", "no-cache, no-store");
        response.header("Pragma", "no-cache");
        long time = System.currentTimeMillis();
        response.header("Last-Modified", time + "");
        response.header("Date", time + "");
        response.header("Expires", time + "");
    }

    @Override
    public boolean verify(String code) {
        return this.verify(code, DEFAULT_SESSION_KEY);
    }

    @Override
    public boolean verify(String code, String sessionKey) {
        Session session = WebContext.request().session();
        String sessionCode = (String)session.attribute(sessionKey);
        return code.equals(sessionCode);
    }

    @Override
    public File create(String imgPath, String imgType) throws PatchcaException {
        try {
            FileOutputStream fos = new FileOutputStream(imgPath);
            EncoderHelper.getChallangeAndWriteImage(this.cs, imgType, fos);
            fos.close();
            return new File(imgPath);
        }
        catch (IOException e) {
            throw new PatchcaException(e);
        }
    }
}

