/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.json;

import blade.kit.json.JSON;
import blade.kit.json.JSONValue;
import blade.kit.json.JSONWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class JSONObject
extends JSONValue
implements Iterable<Member> {
    private final List<String> names;
    private final List<JSONValue> values;
    private transient HashIndexTable table;

    public JSONObject() {
        this.names = new ArrayList<String>();
        this.values = new ArrayList<JSONValue>();
        this.table = new HashIndexTable();
    }

    public JSONObject(JSONObject object) {
        this(object, false);
    }

    private JSONObject(JSONObject object, boolean unmodifiable) {
        if (object == null) {
            throw new NullPointerException("object is null");
        }
        if (unmodifiable) {
            this.names = Collections.unmodifiableList(object.names);
            this.values = Collections.unmodifiableList(object.values);
        } else {
            this.names = new ArrayList<String>(object.names);
            this.values = new ArrayList<JSONValue>(object.values);
        }
        this.table = new HashIndexTable();
        this.updateHashIndex();
    }

    public static JSONObject unmodifiableObject(JSONObject object) {
        return new JSONObject(object, true);
    }

    public JSONObject put(String name, int value) {
        this.put(name, JSON.value(value));
        return this;
    }

    public JSONObject put(String name, Object value) {
        this.put(name, JSON.value(value));
        return this;
    }

    public JSONObject put(String name, long value) {
        this.put(name, JSON.value(value));
        return this;
    }

    public JSONObject put(String name, float value) {
        this.put(name, JSON.value(Float.valueOf(value)));
        return this;
    }

    public JSONObject put(String name, double value) {
        this.put(name, JSON.value(value));
        return this;
    }

    public JSONObject put(String name, boolean value) {
        this.put(name, JSON.value(value));
        return this;
    }

    public JSONObject put(String name, String value) {
        this.put(name, JSON.value(value));
        return this;
    }

    public JSONObject put(String name, JSONValue value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.table.add(name, this.names.size());
        this.names.add(name);
        this.values.add(value);
        return this;
    }

    public JSONObject set(String name, int value) {
        this.set(name, JSON.value(value));
        return this;
    }

    public JSONObject set(String name, long value) {
        this.set(name, JSON.value(value));
        return this;
    }

    public JSONObject set(String name, float value) {
        this.set(name, JSON.value(Float.valueOf(value)));
        return this;
    }

    public JSONObject set(String name, double value) {
        this.set(name, JSON.value(value));
        return this;
    }

    public JSONObject set(String name, boolean value) {
        this.set(name, JSON.value(value));
        return this;
    }

    public JSONObject set(String name, String value) {
        this.set(name, JSON.value(value));
        return this;
    }

    public JSONObject set(String name, JSONValue value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        int index = this.indexOf(name);
        if (index != -1) {
            this.values.set(index, value);
        } else {
            this.table.add(name, this.names.size());
            this.names.add(name);
            this.values.add(value);
        }
        return this;
    }

    public JSONObject remove(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        int index = this.indexOf(name);
        if (index != -1) {
            this.table.remove(index);
            this.names.remove(index);
            this.values.remove(index);
        }
        return this;
    }

    public JSONObject merge(JSONObject object) {
        if (object == null) {
            throw new NullPointerException("object is null");
        }
        for (Member member : object) {
            this.set(member.name, member.value);
        }
        return this;
    }

    public JSONValue get(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        int index = this.indexOf(name);
        return index != -1 ? this.values.get(index) : null;
    }

    public boolean contains(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        int index = this.indexOf(name);
        return index != -1;
    }

    public Integer getInt(String name, Integer defaultValue) {
        JSONValue value = this.get(name);
        return value != null ? value.asInt() : defaultValue;
    }

    public Integer getInt(String name) {
        return this.getInt(name, null);
    }

    public Long getLong(String name, Long defaultValue) {
        JSONValue value = this.get(name);
        return value != null ? value.asLong() : defaultValue;
    }

    public Long getLong(String name) {
        return this.getLong(name, null);
    }

    public Float getFloat(String name, Float defaultValue) {
        JSONValue value = this.get(name);
        return value != null ? value.asFloat() : defaultValue;
    }

    public Float getFloat(String name) {
        return this.getFloat(name, null);
    }

    public Double getDouble(String name, Double defaultValue) {
        JSONValue value = this.get(name);
        return value != null ? value.asDouble() : defaultValue;
    }

    public Double getDouble(String name) {
        return this.getDouble(name, null);
    }

    public Boolean getBoolean(String name, Boolean defaultValue) {
        JSONValue value = this.get(name);
        return value != null ? value.asBoolean() : defaultValue;
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, null);
    }

    public String getString(String name, String defaultValue) {
        JSONValue value = this.get(name);
        return value != null ? value.asString() : defaultValue;
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public int size() {
        return this.names.size();
    }

    public boolean isEmpty() {
        return this.names.isEmpty();
    }

    public List<String> names() {
        return Collections.unmodifiableList(this.names);
    }

    @Override
    public Iterator<Member> iterator() {
        final Iterator<String> namesIterator = this.names.iterator();
        final Iterator<JSONValue> valuesIterator = this.values.iterator();
        return new Iterator<Member>(){

            @Override
            public boolean hasNext() {
                return namesIterator.hasNext();
            }

            @Override
            public Member next() {
                String name = (String)namesIterator.next();
                JSONValue value = (JSONValue)valuesIterator.next();
                return new Member(name, value);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    void write(JSONWriter writer) throws IOException {
        writer.writeObjectOpen();
        Iterator<String> namesIterator = this.names.iterator();
        Iterator<JSONValue> valuesIterator = this.values.iterator();
        boolean first = true;
        while (namesIterator.hasNext()) {
            if (!first) {
                writer.writeObjectSeparator();
            }
            writer.writeMemberName(namesIterator.next());
            writer.writeMemberSeparator();
            valuesIterator.next().write(writer);
            first = false;
        }
        writer.writeObjectClose();
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public JSONObject asJSONObject() {
        return this;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.names.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONObject other = (JSONObject)obj;
        return this.names.equals(other.names) && this.values.equals(other.values);
    }

    int indexOf(String name) {
        int index = this.table.get(name);
        if (index != -1 && name.equals(this.names.get(index))) {
            return index;
        }
        return this.names.lastIndexOf(name);
    }

    private synchronized void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.table = new HashIndexTable();
        this.updateHashIndex();
    }

    private void updateHashIndex() {
        int size = this.names.size();
        for (int i = 0; i < size; ++i) {
            this.table.add(this.names.get(i), i);
        }
    }

    static class HashIndexTable {
        private final byte[] hashTable = new byte[32];

        public HashIndexTable() {
        }

        public HashIndexTable(HashIndexTable original) {
            System.arraycopy(original.hashTable, 0, this.hashTable, 0, this.hashTable.length);
        }

        void add(String name, int index) {
            int slot = this.hashSlotFor(name);
            this.hashTable[slot] = index < 255 ? (byte)(index + 1) : (byte)0;
        }

        void remove(int index) {
            for (int i = 0; i < this.hashTable.length; ++i) {
                if (this.hashTable[i] == index + 1) {
                    this.hashTable[i] = 0;
                    continue;
                }
                if (this.hashTable[i] <= index + 1) continue;
                int n = i;
                this.hashTable[n] = (byte)(this.hashTable[n] - 1);
            }
        }

        int get(Object name) {
            int slot = this.hashSlotFor(name);
            return (this.hashTable[slot] & 0xFF) - 1;
        }

        private int hashSlotFor(Object element) {
            return element.hashCode() & this.hashTable.length - 1;
        }
    }

    public static class Member {
        private final String name;
        private final JSONValue value;

        Member(String name, JSONValue value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public JSONValue getValue() {
            return this.value;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Member other = (Member)obj;
            return this.name.equals(other.name) && this.value.equals(other.value);
        }
    }
}

