/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.json;

import blade.kit.json.JSON;
import blade.kit.json.JSONValue;
import blade.kit.json.JSONWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class JSONArray
extends JSONValue
implements Iterable<JSONValue> {
    private final List<JSONValue> values;

    public JSONArray() {
        this.values = new ArrayList<JSONValue>();
    }

    public JSONArray(JSONArray array) {
        this(array, false);
    }

    private JSONArray(JSONArray array, boolean unmodifiable) {
        if (array == null) {
            throw new NullPointerException("array is null");
        }
        this.values = unmodifiable ? Collections.unmodifiableList(array.values) : new ArrayList<JSONValue>(array.values);
    }

    public static JSONArray unmodifiableArray(JSONArray array) {
        return new JSONArray(array, true);
    }

    public JSONArray add(int value) {
        this.values.add(JSON.value(value));
        return this;
    }

    public JSONArray add(long value) {
        this.values.add(JSON.value(value));
        return this;
    }

    public JSONArray add(float value) {
        this.values.add(JSON.value(Float.valueOf(value)));
        return this;
    }

    public JSONArray add(double value) {
        this.values.add(JSON.value(value));
        return this;
    }

    public JSONArray add(boolean value) {
        this.values.add(JSON.value(value));
        return this;
    }

    public JSONArray add(String value) {
        this.values.add(JSON.value(value));
        return this;
    }

    public JSONArray add(Object value) {
        this.values.add(JSON.value(value));
        return this;
    }

    public JSONArray add(JSONValue value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.values.add(value);
        return this;
    }

    public JSONArray set(int index, int value) {
        this.values.set(index, JSON.value(value));
        return this;
    }

    public JSONArray set(int index, long value) {
        this.values.set(index, JSON.value(value));
        return this;
    }

    public JSONArray set(int index, float value) {
        this.values.set(index, JSON.value(Float.valueOf(value)));
        return this;
    }

    public JSONArray set(int index, double value) {
        this.values.set(index, JSON.value(value));
        return this;
    }

    public JSONArray set(int index, boolean value) {
        this.values.set(index, JSON.value(value));
        return this;
    }

    public JSONArray set(int index, String value) {
        this.values.set(index, JSON.value(value));
        return this;
    }

    public JSONArray set(int index, JSONValue value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.values.set(index, value);
        return this;
    }

    public JSONArray remove(int index) {
        this.values.remove(index);
        return this;
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public JSONValue get(int index) {
        return this.values.get(index);
    }

    public List<JSONValue> values() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public Iterator<JSONValue> iterator() {
        final Iterator<JSONValue> iterator = this.values.iterator();
        return new Iterator<JSONValue>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public JSONValue next() {
                return (JSONValue)iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    void write(JSONWriter writer) throws IOException {
        writer.writeArrayOpen();
        Iterator<JSONValue> iterator = this.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            if (!first) {
                writer.writeArraySeparator();
            }
            iterator.next().write(writer);
            first = false;
        }
        writer.writeArrayClose();
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JSONArray asArray() {
        return this;
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JSONArray other = (JSONArray)object;
        return this.values.equals(other.values);
    }
}

