/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.json;

import blade.kit.json.JSONArray;
import blade.kit.json.JSONHandler;
import blade.kit.json.JSONHelper;
import blade.kit.json.JSONLiteral;
import blade.kit.json.JSONNumber;
import blade.kit.json.JSONObject;
import blade.kit.json.JSONParser;
import blade.kit.json.JSONString;
import blade.kit.json.JSONValue;
import java.io.IOException;
import java.io.Reader;

public final class JSON {
    public static final JSONValue NULL = new JSONLiteral("null");
    public static final JSONValue TRUE = new JSONLiteral("true");
    public static final JSONValue FALSE = new JSONLiteral("false");

    private JSON() {
    }

    public static JSONValue value(Integer value) {
        return new JSONNumber(Integer.toString(value, 10));
    }

    public static JSONValue value(Object value) {
        return JSONHelper.toJSONValue(value);
    }

    public static JSONValue value(Long value) {
        return new JSONNumber(Long.toString(value, 10));
    }

    public static JSONValue value(Byte value) {
        return new JSONNumber(Byte.toString(value));
    }

    public static JSONValue value(Float value) {
        if (Float.isInfinite(value.floatValue()) || Float.isNaN(value.floatValue())) {
            throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
        }
        return new JSONNumber(JSON.cutOffPointZero(Float.toString(value.floatValue())));
    }

    public static JSONValue value(Double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new IllegalArgumentException("Infinite and NaN values not permitted in JSON");
        }
        return new JSONNumber(JSON.cutOffPointZero(Double.toString(value)));
    }

    public static JSONValue value(String string) {
        return string == null ? NULL : new JSONString(string);
    }

    public static JSONValue value(Boolean value) {
        return value != false ? TRUE : FALSE;
    }

    public static JSONValue array() {
        return new JSONArray();
    }

    public static JSONArray array(Integer ... values) {
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        JSONArray array = new JSONArray();
        Integer[] integerArray = values;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int value = integerArray[i];
            array.add(value);
        }
        return array;
    }

    public static JSONArray array(Long ... values) {
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        JSONArray array = new JSONArray();
        Long[] longArray = values;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long value = longArray[i];
            array.add(value);
        }
        return array;
    }

    public static JSONArray array(Float ... values) {
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        JSONArray array = new JSONArray();
        Float[] floatArray = values;
        int n = floatArray.length;
        for (int i = 0; i < n; ++i) {
            float value = floatArray[i].floatValue();
            array.add(value);
        }
        return array;
    }

    public static JSONArray array(Double ... values) {
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        JSONArray array = new JSONArray();
        Double[] doubleArray = values;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double value = doubleArray[i];
            array.add(value);
        }
        return array;
    }

    public static JSONArray array(Boolean ... values) {
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        JSONArray array = new JSONArray();
        Boolean[] booleanArray = values;
        int n = booleanArray.length;
        for (int i = 0; i < n; ++i) {
            boolean value = booleanArray[i];
            array.add(value);
        }
        return array;
    }

    public static JSONArray array(String ... strings) {
        if (strings == null) {
            throw new NullPointerException("values is null");
        }
        JSONArray array = new JSONArray();
        for (String value : strings) {
            array.add(value);
        }
        return array;
    }

    public static JSONObject create() {
        return new JSONObject();
    }

    public static JSONValue parse(String string) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        DefaultHandler handler = new DefaultHandler();
        new JSONParser(handler).parse(string);
        return handler.getValue();
    }

    public static JSONValue parse(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        DefaultHandler handler = new DefaultHandler();
        new JSONParser(handler).parse(reader);
        return handler.getValue();
    }

    private static String cutOffPointZero(String string) {
        if (string.endsWith(".0")) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    static class DefaultHandler
    extends JSONHandler<JSONArray, JSONObject> {
        protected JSONValue value;

        DefaultHandler() {
        }

        @Override
        public JSONArray startArray() {
            return new JSONArray();
        }

        @Override
        public JSONObject startObject() {
            return new JSONObject();
        }

        @Override
        public void endNull() {
            this.value = NULL;
        }

        @Override
        public void endBoolean(boolean bool) {
            this.value = bool ? TRUE : FALSE;
        }

        @Override
        public void endString(String string) {
            this.value = new JSONString(string);
        }

        @Override
        public void endNumber(String string) {
            this.value = new JSONNumber(string);
        }

        @Override
        public void endArray(JSONArray array) {
            this.value = array;
        }

        @Override
        public void endObject(JSONObject object) {
            this.value = object;
        }

        @Override
        public void endArrayValue(JSONArray array) {
            array.add(this.value);
        }

        @Override
        public void endObjectValue(JSONObject object, String name) {
            object.put(name, this.value);
        }

        JSONValue getValue() {
            return this.value;
        }
    }
}

