/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.http;

import blade.kit.http.HttpRequest;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class RequestOutputStream
extends BufferedOutputStream {
    final CharsetEncoder encoder;

    public RequestOutputStream(OutputStream stream, String charset, int bufferSize) {
        super(stream, bufferSize);
        this.encoder = Charset.forName(HttpRequest.getValidCharset(charset)).newEncoder();
    }

    public RequestOutputStream write(String value) throws IOException {
        ByteBuffer bytes = this.encoder.encode(CharBuffer.wrap(value));
        super.write(bytes.array(), 0, bytes.limit());
        return this;
    }
}

