/*
 * Decompiled with CFR 0.152.
 */
package blade.kit.config.adapter;

import blade.kit.CollectionKit;
import blade.kit.IOKit;
import blade.kit.config.Config;
import blade.kit.config.adapter.ConfigAdapter;
import blade.kit.config.exception.ConfigAdapterException;
import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropConfigAdapter
extends ConfigAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropConfigAdapter.class);

    @Override
    public Config read(String prop_file) {
        Set<Map.Entry<Object, Object>> set;
        InputStream in;
        block7: {
            Properties props = new Properties();
            in = null;
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(prop_file);
            if (in == null) break block7;
            props.load(in);
            set = props.entrySet();
            if (!CollectionKit.isNotEmpty(set)) break block7;
            for (Map.Entry<Object, Object> entry : set) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                String fuKey = this.getWildcard(value);
                if (null != fuKey && null != props.get(fuKey)) {
                    String fuValue = props.get(fuKey).toString();
                    value = value.replaceAll("\\$\\{" + fuKey + "\\}", fuValue);
                }
                this.configMap.put(key, value);
            }
            LOGGER.info("Loading config file [classpath:/" + prop_file + "]");
            PropConfigAdapter propConfigAdapter = this;
            IOKit.closeQuietly(in);
            return propConfigAdapter;
        }
        try {
            set = null;
        }
        catch (IOException e) {
            try {
                throw new ConfigAdapterException("load properties file error!");
            }
            catch (Throwable throwable) {
                IOKit.closeQuietly(in);
                throw throwable;
            }
        }
        IOKit.closeQuietly(in);
        return set;
    }

    private String getWildcard(String str) {
        if (null != str && str.indexOf("${") != -1) {
            int start = str.indexOf("${");
            int end = str.indexOf("}");
            if (start != -1 && end != -1) {
                return str.substring(start + 2, end);
            }
        }
        return null;
    }

    @Override
    public Map<String, String> getConfigMap() {
        return this.configMap;
    }
}

