/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

public class ShellKit {
    public static final String COMMAND_SU = "su";
    public static final String COMMAND_SH = "sh";
    public static final String COMMAND_EXIT = "exit\n";
    public static final String COMMAND_LINE_END = "\n";

    public static boolean hasRootPermission() {
        return ShellKit.execCommand((String)"echo root", (boolean)true, (boolean)false).result == 0;
    }

    public static CommandResult execCommand(String command, boolean isRoot) {
        return ShellKit.execCommand(new String[]{command}, isRoot, true);
    }

    public static CommandResult execCommand(String command, boolean isRoot, boolean isNeedResultMsg) {
        return ShellKit.execCommand(new String[]{command}, isRoot, isNeedResultMsg);
    }

    public static CommandResult execCommand(List<String> commands, boolean isRoot, boolean isNeedResultMsg) {
        return ShellKit.execCommand(commands == null ? null : commands.toArray(new String[0]), isRoot, isNeedResultMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CommandResult execCommand(String[] commands, boolean isRoot, boolean needResponse) {
        String string;
        int result = -1;
        if (commands == null) return new CommandResult(result, null, "\u7a7a\u547d\u4ee4");
        if (commands.length == 0) {
            return new CommandResult(result, null, "\u7a7a\u547d\u4ee4");
        }
        Process process = null;
        BufferedReader successResult = null;
        BufferedReader errorResult = null;
        StringBuilder successMsg = null;
        StringBuilder errorMsg = null;
        FilterOutputStream os = null;
        try {
            process = Runtime.getRuntime().exec(isRoot ? COMMAND_SU : COMMAND_SH);
            os = new DataOutputStream(process.getOutputStream());
            for (String command : commands) {
                if (command == null) continue;
                os.write(command.getBytes());
                ((DataOutputStream)os).writeBytes(COMMAND_LINE_END);
                ((DataOutputStream)os).flush();
            }
            ((DataOutputStream)os).writeBytes(COMMAND_EXIT);
            ((DataOutputStream)os).flush();
            result = process.waitFor();
            if (needResponse) {
                String s;
                successMsg = new StringBuilder();
                errorMsg = new StringBuilder();
                successResult = new BufferedReader(new InputStreamReader(process.getInputStream()));
                errorResult = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((s = successResult.readLine()) != null) {
                    successMsg.append(s);
                }
                while ((s = errorResult.readLine()) != null) {
                    errorMsg.append(s);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (errorResult != null) {
                    errorResult.close();
                }
                if (successResult != null) {
                    successResult.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
        String string2 = successMsg == null ? null : successMsg.toString();
        if (errorMsg == null) {
            string = null;
            return new CommandResult(result, string2, string);
        }
        string = errorMsg.toString();
        return new CommandResult(result, string2, string);
    }

    public static class CommandResult {
        public int result;
        public String responseMsg;
        public String errorMsg;

        public CommandResult(int result) {
            this.result = result;
        }

        public CommandResult(int result, String responseMsg, String errorMsg) {
            this.result = result;
            this.responseMsg = responseMsg;
            this.errorMsg = errorMsg;
        }
    }
}

