/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import blade.kit.DateKit;
import blade.kit.exception.ReflectException;
import blade.kit.reflect.ReflectKit;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;

public final class ObjectKit {
    private ObjectKit() {
    }

    public static <T> T model(String slug, Class<?> clazz, Map<String, String> params) {
        try {
            Object obj = ReflectKit.newInstance(clazz);
            Field[] fields = clazz.getDeclaredFields();
            if (null == fields || fields.length == 0) {
                return null;
            }
            for (Field field : fields) {
                String fieldName;
                String fieldValue;
                field.setAccessible(true);
                if (field.getName().equals("serialVersionUID") || null == (fieldValue = params.get(fieldName = slug + "." + field.getName()))) continue;
                Object value = ObjectKit.parse(field.getType(), fieldValue);
                field.set(obj, value);
            }
            return (T)obj;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            throw new ReflectException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectException(e);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object parse(Class<?> type, String value) {
        if (type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == String.class) {
            return value;
        }
        if (type == Date.class) {
            return DateKit.convertToDate(value);
        }
        if (type == Double.class) {
            return Double.parseDouble(value);
        }
        if (type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Long.class) {
            return Long.parseLong(value);
        }
        if (type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (type == Short.class) {
            return Short.parseShort(value);
        }
        return value;
    }
}

