/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class CollectionKit {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 4;

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return new HashMap(size);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int size) {
        return new LinkedHashMap(size);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap(16, 0.75f, 4);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int size) {
        return new ConcurrentHashMap(size);
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> newArrayList(int size) {
        return new ArrayList(size);
    }

    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    public static <T> HashSet<T> newHashSet(int size) {
        return new HashSet(size);
    }

    public static <T> TreeSet<T> newTreeSet() {
        return new TreeSet();
    }

    public static <K, V> Map<K, V> sortMap(Map<K, V> map, Comparator<Map.Entry<K, V>> compator) {
        LinkedHashMap result = new LinkedHashMap();
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, compator);
        for (Map.Entry entry : entries) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return null == map || map.isEmpty();
    }

    public static <T> boolean isEmpty(T[] arr) {
        return null == arr || arr.length == 0;
    }

    public static <T> T[] concat(T[] a, T[] b) {
        int alen = a.length;
        int blen = b.length;
        if (alen == 0) {
            return b;
        }
        if (blen == 0) {
            return a;
        }
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), alen + blen);
        System.arraycopy(a, 0, result, 0, alen);
        System.arraycopy(b, 0, result, alen, blen);
        return result;
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return map != null && map.size() > 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && collection.size() > 0;
    }

    public static boolean hasItems(Enumeration<?> enums) {
        return enums != null && enums.hasMoreElements();
    }

    public static boolean hasNotItems(Enumeration<?> enums) {
        return enums == null || !enums.hasMoreElements();
    }

    public static boolean hasItems(Iterator<?> iters) {
        return iters != null && iters.hasNext();
    }

    public static boolean hasNotItems(Iterator<?> iters) {
        return iters != null && iters.hasNext();
    }

    public static <E> ArrayList<E> createArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> createArrayList(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    public static <E> ArrayList<E> createArrayList(Collection<? extends E> collection) {
        if (collection == null) {
            return new ArrayList();
        }
        return new ArrayList<E>(collection);
    }

    public static <E> ArrayList<E> createArrayList(Iterable<? extends E> iter) {
        if (iter instanceof Collection) {
            return new ArrayList((Collection)iter);
        }
        ArrayList list = new ArrayList();
        CollectionKit.iterableToCollection(iter, list);
        list.trimToSize();
        return list;
    }

    public static <T, V extends T> ArrayList<T> createArrayList(V ... args) {
        if (args == null || args.length == 0) {
            return new ArrayList();
        }
        ArrayList<V> list = new ArrayList<V>(args.length);
        for (V v : args) {
            list.add(v);
        }
        return list;
    }

    public static <E> LinkedList<E> createLinkedList() {
        return new LinkedList();
    }

    public static <E> LinkedList<E> createLinkedList(Collection<? extends E> collection) {
        if (collection == null) {
            return new LinkedList();
        }
        return new LinkedList<E>(collection);
    }

    public static <T> LinkedList<T> createLinkedList(Iterable<? extends T> c) {
        LinkedList list = new LinkedList();
        CollectionKit.iterableToCollection(c, list);
        return list;
    }

    public static <T, V extends T> LinkedList<T> createLinkedList(V ... args) {
        LinkedList<V> list = new LinkedList<V>();
        if (args != null) {
            for (V v : args) {
                list.add(v);
            }
        }
        return list;
    }

    public static <T> List<T> asList(T ... args) {
        if (args == null || args.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(args);
    }

    public static <E> HashSet<E> createHashSet() {
        return new HashSet();
    }

    public static <E> HashSet<E> createHashSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    public static <E> HashSet<E> createHashSet(Collection<? extends E> collection) {
        if (collection == null) {
            return new HashSet();
        }
        return new HashSet<E>(collection);
    }

    public static <E, O extends E> HashSet<E> createHashSet(O ... args) {
        if (args == null || args.length == 0) {
            return new HashSet();
        }
        HashSet<O> set = new HashSet<O>(args.length);
        for (O o : args) {
            set.add(o);
        }
        return set;
    }

    public static <T> HashSet<T> createHashSet(Iterable<? extends T> iter) {
        HashSet set;
        if (iter instanceof Collection) {
            set = new HashSet((Collection)iter);
        } else {
            set = new HashSet();
            CollectionKit.iterableToCollection(iter, set);
        }
        return set;
    }

    public static <E> LinkedHashSet<E> createLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <T, V extends T> LinkedHashSet<T> createLinkedHashSet(V ... args) {
        if (args == null || args.length == 0) {
            return new LinkedHashSet();
        }
        LinkedHashSet<V> set = new LinkedHashSet<V>(args.length);
        for (V v : args) {
            set.add(v);
        }
        return set;
    }

    public static <T> LinkedHashSet<T> createLinkedHashSet(Iterable<? extends T> iter) {
        LinkedHashSet set;
        if (iter instanceof Collection) {
            set = new LinkedHashSet((Collection)iter);
        } else {
            set = new LinkedHashSet();
            CollectionKit.iterableToCollection(iter, set);
        }
        return set;
    }

    public static <T, V extends T> TreeSet<T> createTreeSet(V ... args) {
        return CollectionKit.createTreeSet(null, args);
    }

    public static <T> TreeSet<T> createTreeSet(Iterable<? extends T> c) {
        return CollectionKit.createTreeSet(null, c);
    }

    public static <T> TreeSet<T> createTreeSet(Comparator<? super T> comparator) {
        return new TreeSet<T>(comparator);
    }

    public static <T, V extends T> TreeSet<T> createTreeSet(Comparator<? super T> comparator, V ... args) {
        TreeSet<T> set = new TreeSet<T>(comparator);
        if (args != null) {
            for (V v : args) {
                set.add(v);
            }
        }
        return set;
    }

    public static <T> TreeSet<T> createTreeSet(Comparator<? super T> comparator, Iterable<? extends T> c) {
        TreeSet<? super T> set = new TreeSet<T>(comparator);
        CollectionKit.iterableToCollection(c, set);
        return set;
    }

    public static <E> TreeSet<E> createTreeSet(SortedSet<E> set) {
        if (set == null) {
            return new TreeSet();
        }
        return new TreeSet<E>(set);
    }

    public static <K, V> HashMap<K, V> createHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> createHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> createHashMap(int initialCapacity, float loadFactor) {
        return new HashMap(initialCapacity, loadFactor);
    }

    public static <K, V> HashMap<K, V> synchronizedMap() {
        return (HashMap)Collections.synchronizedMap(new HashMap());
    }

    public static <K, V> HashMap<K, V> createHashMap(Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> LinkedHashMap<K, V> createLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> LinkedHashMap<K, V> createLinkedHashMap(int initialCapacity) {
        return new LinkedHashMap(initialCapacity);
    }

    public static <K, V> LinkedHashMap<K, V> createLinkedHashMap(int initialCapacity, float loadFactor) {
        return new LinkedHashMap(initialCapacity, loadFactor);
    }

    public static <K, V> LinkedHashMap<K, V> createLinkedHashMap(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return new LinkedHashMap();
        }
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentMap(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return null;
        }
        return new ConcurrentHashMap<K, V>(map);
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity, float loadFactor) {
        return new ConcurrentHashMap(initialCapacity, loadFactor);
    }

    private static <E> void iterableToCollection(Iterable<? extends E> iter, Collection<E> list) {
        if (iter == null) {
            return;
        }
        for (E element : iter) {
            list.add(element);
        }
    }

    public static <E extends Enum<E>> EnumSet<E> createEnumSet(Collection<E> c) {
        if (c == null) {
            return null;
        }
        return EnumSet.copyOf(c);
    }

    public static <E extends Enum<E>> EnumSet<E> createEnumSet(Class<E> elementType) {
        if (elementType == null) {
            return null;
        }
        return EnumSet.allOf(elementType);
    }

    public static <K, V> TreeMap<K, V> createTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> createTreeMap(Comparator<? super K> comparator) {
        if (comparator == null) {
            return null;
        }
        return new TreeMap(comparator);
    }

    public static <K, V> TreeMap<K, V> createTreeMap(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return null;
        }
        return new TreeMap<K, V>(map);
    }

    public static <K, V> TreeMap<K, V> createTreeMap(SortedMap<K, ? extends V> map) {
        if (map == null) {
            return null;
        }
        return new TreeMap<K, V>(map);
    }

    public static <K, V> WeakHashMap<K, V> createWeakHashMap() {
        return new WeakHashMap();
    }

    public static <K, V> WeakHashMap<K, V> createWeakHashMap(int initialCapacity) {
        return new WeakHashMap(initialCapacity);
    }

    public static <K, V> WeakHashMap<K, V> createWeakHashMap(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return new WeakHashMap();
        }
        return new WeakHashMap<K, V>(map);
    }

    public static <K, V> WeakHashMap<K, V> createWeakHashMap(int initialCapacity, float loadFactor) {
        return new WeakHashMap(initialCapacity, loadFactor);
    }

    public static <K, V> IdentityHashMap<K, V> createIdentityHashMap() {
        return new IdentityHashMap();
    }

    public static <K, V> IdentityHashMap<K, V> createIdentityHashMap(int initialCapacity) {
        return new IdentityHashMap(initialCapacity);
    }

    public static <K, V> IdentityHashMap<K, V> createIdentityHashMap(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return null;
        }
        return new IdentityHashMap<K, V>(map);
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> createEnumMap(Class<K> keyType) {
        if (keyType == null) {
            return null;
        }
        return new EnumMap(keyType);
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> createEnumMap(Map<K, ? extends V> map) {
        if (map == null) {
            return null;
        }
        return new EnumMap<K, V>(map);
    }

    public static <E> PriorityQueue<E> createPriorityQueue() {
        return new PriorityQueue();
    }

    public static <E> PriorityQueue<E> createPriorityQueue(int initialCapacity) {
        return new PriorityQueue(initialCapacity);
    }

    public static <E> PriorityQueue<E> createPriorityQueue(Collection<? extends E> collection) {
        if (collection == null) {
            return null;
        }
        return new PriorityQueue<E>(collection);
    }

    public static <E> PriorityQueue<E> createPriorityQueue(int initialCapacity, Comparator<? super E> comparator) {
        if (comparator == null) {
            return new PriorityQueue(initialCapacity);
        }
        return new PriorityQueue<E>(initialCapacity, comparator);
    }

    public static <E> PriorityQueue<E> createPriorityQueue(PriorityQueue<? extends E> queue) {
        if (queue == null) {
            return null;
        }
        return new PriorityQueue<E>(queue);
    }

    public static <E> PriorityQueue<E> createPriorityQueue(SortedSet<? extends E> set) {
        if (set == null) {
            return null;
        }
        return new PriorityQueue<E>(set);
    }

    public static <E> ArrayDeque<E> createArrayDeque() {
        return new ArrayDeque();
    }

    public static <E> ArrayDeque<E> createArrayDeque(Collection<? extends E> collection) {
        if (collection == null) {
            return null;
        }
        return new ArrayDeque<E>(collection);
    }

    public static <E> ArrayDeque<E> createArrayDeque(int initialCapacity) {
        return new ArrayDeque(initialCapacity);
    }

    public static <E> BitSet createBitSet() {
        return new BitSet();
    }

    public static <E> BitSet createBitSet(int initialCapacity) {
        return new BitSet();
    }

    public static <K, V> ConcurrentSkipListMap<K, V> createConcurrentSkipListMap() {
        return new ConcurrentSkipListMap();
    }

    public static <K, V> ConcurrentSkipListMap<K, V> createConcurrentSkipListMap(Comparator<? super K> comparator) {
        if (comparator == null) {
            return new ConcurrentSkipListMap();
        }
        return new ConcurrentSkipListMap(comparator);
    }

    public static <K, V> ConcurrentSkipListMap<K, V> createConcurrentSkipListMap(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return new ConcurrentSkipListMap();
        }
        return new ConcurrentSkipListMap<K, V>(map);
    }

    public static <K, V> ConcurrentSkipListMap<K, V> createConcurrentSkipListMap(SortedMap<? extends K, ? extends V> map) {
        if (map == null) {
            return new ConcurrentSkipListMap();
        }
        return new ConcurrentSkipListMap<K, V>(map);
    }

    public static <E> ConcurrentSkipListSet<E> createConcurrentSkipListSet() {
        return new ConcurrentSkipListSet();
    }

    public static <E> ConcurrentSkipListSet<E> createConcurrentSkipListSet(Collection<? extends E> collection) {
        if (collection == null) {
            return new ConcurrentSkipListSet();
        }
        return new ConcurrentSkipListSet<E>(collection);
    }

    public static <E> ConcurrentSkipListSet<E> createConcurrentSkipListSet(Comparator<? super E> comparator) {
        if (comparator == null) {
            return new ConcurrentSkipListSet();
        }
        return new ConcurrentSkipListSet<E>(comparator);
    }

    public static <E> ConcurrentSkipListSet<E> createConcurrentSkipListSet(SortedSet<E> set) {
        if (set == null) {
            return new ConcurrentSkipListSet();
        }
        return new ConcurrentSkipListSet<E>(set);
    }

    public static <E> Queue<E> createConcurrentLinkedQueue() {
        return new ConcurrentLinkedQueue();
    }

    public static <E> Queue<E> createConcurrentLinkedQueue(Collection<? extends E> collection) {
        if (collection == null) {
            return new ConcurrentLinkedQueue();
        }
        return new ConcurrentLinkedQueue<E>(collection);
    }

    public static <E> CopyOnWriteArrayList<E> createCopyOnWriteArrayList() {
        return new CopyOnWriteArrayList();
    }

    public static <E> CopyOnWriteArrayList<E> createCopyOnWriteArrayList(Collection<? extends E> collection) {
        if (collection == null) {
            return new CopyOnWriteArrayList();
        }
        return new CopyOnWriteArrayList();
    }

    public static <E> CopyOnWriteArrayList<E> createCopyOnWriteArrayList(E[] toCopyIn) {
        if (toCopyIn == null) {
            return new CopyOnWriteArrayList();
        }
        return new CopyOnWriteArrayList<E>(toCopyIn);
    }

    public static <E> CopyOnWriteArraySet<E> createCopyOnWriteArraySet() {
        return new CopyOnWriteArraySet();
    }

    public static <E> CopyOnWriteArraySet<E> createCopyOnWriteArraySet(Collection<? extends E> collection) {
        return new CopyOnWriteArraySet();
    }

    public static <E> BlockingQueue<E> createLinkedBlockingQueue() {
        return new LinkedBlockingQueue();
    }

    public static <E> BlockingQueue<E> createLinkedBlockingQueue(int capacity) {
        return new LinkedBlockingQueue(capacity);
    }

    public static <E> BlockingQueue<E> createLinkedBlockingQueue(Collection<? extends E> collection) {
        if (collection == null) {
            return new LinkedBlockingQueue();
        }
        return new LinkedBlockingQueue<E>(collection);
    }

    public static String[] arrayToHeavy(String[] arr) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < arr.length; ++i) {
            set.add(arr[i]);
        }
        String[] a = set.toArray(new String[set.size()]);
        return a;
    }

    public static <T> List<T> listToHeavy(List<T> list) {
        HashSet<T> set = new HashSet<T>(list);
        list.clear();
        list.addAll(set);
        return list;
    }

    public static final <T> Set<T> intersection(Set<T> set1, Set<T> set2) {
        if (set1 == null || set2 == null) {
            return null;
        }
        if (set1.isEmpty() || set2.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<T> result = CollectionKit.createHashSet();
        Set<T> smaller = set1.size() > set2.size() ? set2 : set1;
        Set<T> bigger = smaller == set2 ? set1 : set2;
        for (T value : smaller) {
            if (!bigger.contains(value)) continue;
            result.add(value);
        }
        return result;
    }

    public static <T> Set<T> subtract(Set<T> set1, Set<T> set2) {
        if (set1 == null || set2 == null) {
            return null;
        }
        HashSet<T> result = CollectionKit.createHashSet(set1);
        result.removeAll(set2);
        return result;
    }

    public static <T> Set<T> union(Set<T> set1, Set<T> set2) {
        if (CollectionKit.isEmpty(set1)) {
            return set2;
        }
        if (CollectionKit.isEmpty(set2)) {
            return set1;
        }
        HashSet<T> result = CollectionKit.createHashSet(set1);
        result.addAll(set2);
        return result;
    }

    public static <T> List<? extends T> concatSuper(List<? extends T> collection1, List<? extends T> collection2) {
        if (CollectionKit.isEmpty(collection1)) {
            return collection2;
        }
        if (CollectionKit.isEmpty(collection2)) {
            return collection1;
        }
        ArrayList<T> result = CollectionKit.createArrayList(collection1.size() + collection2.size());
        result.addAll(collection1);
        result.addAll(collection2);
        return result;
    }

    public static <T> List<T> concat(List<T> collection1, List<T> collection2) {
        if (CollectionKit.isEmpty(collection1)) {
            return collection2;
        }
        if (CollectionKit.isEmpty(collection2)) {
            return collection1;
        }
        collection1.addAll(collection2);
        return collection1;
    }
}

