/*
 * Decompiled with CFR 0.152.
 */
package blade.kit;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class CloneKit {
    static Class<?>[] needlessCloneClasses = new Class[]{String.class, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class, Object.class, Class.class};

    private static boolean isNeedlessClone(Class<?> c) {
        if (c.isPrimitive()) {
            return true;
        }
        for (Class<?> tmp : needlessCloneClasses) {
            if (!c.equals(tmp)) continue;
            return true;
        }
        return false;
    }

    private static Object createObject(Object value) throws IllegalAccessException {
        try {
            return value.getClass().newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw e;
        }
    }

    public static Object clone(Object value, int level) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (value == null) {
            return null;
        }
        if (level == 0) {
            return value;
        }
        Class<?> c = value.getClass();
        if (CloneKit.isNeedlessClone(c)) {
            return value;
        }
        --level;
        if (value instanceof Collection) {
            Collection tmp = (Collection)c.newInstance();
            for (Object v : (Collection)value) {
                tmp.add(CloneKit.clone(v, level));
            }
            value = tmp;
        } else if (c.isArray()) {
            if (c.equals(int[].class)) {
                int[] old = (int[])value;
                value = Arrays.copyOf(old, old.length);
            } else if (c.equals(short[].class)) {
                short[] old = (short[])value;
                value = Arrays.copyOf(old, old.length);
            } else if (c.equals(char[].class)) {
                char[] old = (char[])value;
                value = Arrays.copyOf(old, old.length);
            } else if (c.equals(float[].class)) {
                float[] old = (float[])value;
                value = Arrays.copyOf(old, old.length);
            } else if (c.equals(double[].class)) {
                double[] old = (double[])value;
                value = Arrays.copyOf(old, old.length);
            } else if (c.equals(long[].class)) {
                long[] old = (long[])value;
                value = Arrays.copyOf(old, old.length);
            } else if (c.equals(boolean[].class)) {
                boolean[] old = (boolean[])value;
                value = Arrays.copyOf(old, old.length);
            } else if (c.equals(byte[].class)) {
                byte[] old = (byte[])value;
                value = Arrays.copyOf(old, old.length);
            } else {
                Object[] old = value;
                T[] tmp = Arrays.copyOf(old, old.length, old.getClass());
                for (int i = 0; i < old.length; ++i) {
                    tmp[i] = CloneKit.clone(old[i], level);
                }
                value = tmp;
            }
        } else if (value instanceof Map) {
            Map tmp = (Map)c.newInstance();
            Map org = (Map)value;
            for (Object key : org.keySet()) {
                tmp.put(key, CloneKit.clone(org.get(key), level));
            }
            value = tmp;
        } else {
            Object tmp = CloneKit.createObject(value);
            if (tmp == null) {
                return value;
            }
            HashSet<Field> fields = new HashSet<Field>();
            while (c != null && !c.equals(Object.class)) {
                fields.addAll(Arrays.asList(c.getDeclaredFields()));
                c = c.getSuperclass();
            }
            for (Field field : fields) {
                if (Modifier.isFinal(field.getModifiers())) continue;
                field.setAccessible(true);
                field.set(tmp, CloneKit.clone(field.get(value), level));
            }
            value = tmp;
        }
        return value;
    }

    public static Object clone(Object value) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        return CloneKit.clone(value, 1);
    }

    public static Object deepClone(Object value) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        return CloneKit.clone(value, -1);
    }
}

