/*
 * Decompiled with CFR 0.152.
 */
package com.blade.web.verify;

import blade.kit.HashidKit;
import blade.kit.StringKit;
import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import com.blade.web.http.Request;
import com.blade.web.http.Response;
import com.blade.web.http.wrapper.Session;
import com.blade.web.verify.CSRFConfig;

public class CSRFTokenManager {
    private static Logger LOGGER = LoggerFactory.getLogger(CSRFTokenManager.class);
    private static CSRFConfig config = new CSRFConfig();
    private static HashidKit HASHID = new HashidKit(CSRFTokenManager.config.secret, CSRFTokenManager.config.length);

    private CSRFTokenManager() {
    }

    public static void config(CSRFConfig config) {
        CSRFTokenManager.config = config;
        HASHID = new HashidKit(config.secret, config.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createToken(Request request, Response response) {
        String token = null;
        Request request2 = request;
        synchronized (request2) {
            Session session = request.session();
            String objToken = (String)session.attribute(CSRFTokenManager.config.session);
            if (StringKit.isBlank((String)objToken)) {
                token = CSRFTokenManager.createNewToken(request, response);
                LOGGER.debug("create csrf_token\uff1a{}", new Object[]{token});
            } else {
                token = objToken;
                session.attribute(CSRFTokenManager.config.session, token);
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createNewToken(Request request, Response response) {
        String token = null;
        Request request2 = request;
        synchronized (request2) {
            Session session = request.session();
            session.removeAttribute(CSRFTokenManager.config.session);
            token = HASHID.encode(new long[]{System.currentTimeMillis()});
            session.attribute(CSRFTokenManager.config.session, token);
            if (CSRFTokenManager.config.setHeader) {
                response.header(CSRFTokenManager.config.header, token);
            }
            if (CSRFTokenManager.config.setCookie) {
                response.cookie(CSRFTokenManager.config.cookiePath, CSRFTokenManager.config.cookie, token, CSRFTokenManager.config.expire, CSRFTokenManager.config.secured);
            }
            LOGGER.debug("create csrf_token\uff1a{}", new Object[]{token});
        }
        return token;
    }

    public static boolean verify(Request request, Response response) {
        String sToken = (String)request.session().attribute(CSRFTokenManager.config.session);
        if (sToken == null) {
            sToken = CSRFTokenManager.createToken(request, response);
            return true;
        }
        String pToken = request.query(CSRFTokenManager.config.form);
        if (CSRFTokenManager.config.setHeader) {
            pToken = request.header(CSRFTokenManager.config.form);
        }
        if (CSRFTokenManager.config.setCookie) {
            pToken = request.cookie(CSRFTokenManager.config.form);
        }
        return StringKit.isNotBlank((String)pToken) && sToken.equals(pToken);
    }

    public static boolean verifyAsForm(Request request, Response response) {
        String sToken = (String)request.session().attribute(CSRFTokenManager.config.session);
        if (sToken == null) {
            sToken = CSRFTokenManager.createToken(request, response);
            return true;
        }
        String pToken = request.query(CSRFTokenManager.config.form);
        if (CSRFTokenManager.config.setHeader) {
            pToken = request.header(CSRFTokenManager.config.form);
        }
        if (CSRFTokenManager.config.setCookie) {
            pToken = request.cookie(CSRFTokenManager.config.form);
        }
        return StringKit.isNotBlank((String)pToken) && sToken.equals(pToken);
    }

    public static boolean verifyAsHeader(Request request, Response response) {
        String sToken = (String)request.session().attribute(CSRFTokenManager.config.session);
        if (sToken == null) {
            sToken = CSRFTokenManager.createToken(request, response);
            return true;
        }
        String pToken = request.header(CSRFTokenManager.config.header);
        return StringKit.isNotBlank((String)pToken) && sToken.equals(pToken);
    }

    public static boolean verifyAsCookie(Request request, Response response) {
        String sToken = (String)request.session().attribute(CSRFTokenManager.config.session);
        if (sToken == null) {
            sToken = CSRFTokenManager.createToken(request, response);
            return true;
        }
        String pToken = request.cookie(CSRFTokenManager.config.cookie);
        return StringKit.isNotBlank((String)pToken) && sToken.equals(pToken);
    }
}

