/*
 * Decompiled with CFR 0.152.
 */
package com.blade.web.http.wrapper;

import blade.kit.IOKit;
import blade.kit.ObjectKit;
import blade.kit.StringKit;
import com.blade.Blade;
import com.blade.route.Route;
import com.blade.web.http.HttpMethod;
import com.blade.web.http.Path;
import com.blade.web.http.Request;
import com.blade.web.http.wrapper.Session;
import com.blade.web.multipart.FileItem;
import com.blade.web.multipart.Multipart;
import com.blade.web.multipart.MultipartException;
import com.blade.web.multipart.MultipartHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ServletRequest
implements Request {
    private static final String USER_AGENT = "user-agent";
    protected Route route;
    private HttpServletRequest request;
    protected Map<String, String> pathParams = null;
    private Map<String, String> multipartParams = null;
    private List<FileItem> files = null;
    private Session session = null;
    private Blade blade = null;
    private boolean isAbort = false;

    public ServletRequest(HttpServletRequest request) throws MultipartException, IOException {
        this.request = request;
        this.pathParams = new HashMap<String, String>();
        this.multipartParams = new HashMap<String, String>();
        this.files = new ArrayList<FileItem>();
        this.blade = Blade.me();
        this.init();
    }

    public ServletRequest init() throws IOException, MultipartException {
        if (Multipart.isMultipartContent(this.request)) {
            Multipart multipart = new Multipart();
            multipart.parse(this.request, new MultipartHandler(){

                @Override
                public void handleFormItem(String name, String value) {
                    ServletRequest.this.multipartParams.put(name, value);
                }

                @Override
                public void handleFileItem(String name, FileItem fileItem) {
                    ServletRequest.this.files.add(fileItem);
                }
            });
        }
        return this;
    }

    private String join(String[] arr) {
        String ret = "";
        for (String item : arr) {
            ret = ret + "," + item;
        }
        if (ret.length() > 0) {
            ret = ret.substring(1);
        }
        return ret;
    }

    @Override
    public void initPathParams(String routePath) {
        this.pathParams.clear();
        List<String> variables = this.getPathParam(routePath);
        String regexPath = routePath.replaceAll(":(\\w+)", "([^#/?]+)");
        String uri = Path.getRelativePath(this.uri(), this.contextPath());
        Matcher matcher = Pattern.compile("(?i)" + regexPath).matcher(uri);
        if (matcher.matches()) {
            int len = variables.size();
            for (int i = 1; i <= len; ++i) {
                String value = matcher.group(i);
                this.pathParams.put(variables.get(i - 1), value);
            }
        }
    }

    private List<String> getPathParam(String routePath) {
        ArrayList<String> variables = new ArrayList<String>();
        Matcher matcher = Pattern.compile(":(\\w+)").matcher(routePath);
        while (matcher.find()) {
            variables.add(matcher.group(1));
        }
        return variables;
    }

    @Override
    public HttpServletRequest raw() {
        return this.request;
    }

    @Override
    public String host() {
        return this.request.getServerName();
    }

    @Override
    public String url() {
        return this.request.getRequestURL().toString();
    }

    @Override
    public String uri() {
        return Path.fixPath(this.request.getRequestURI());
    }

    @Override
    public String userAgent() {
        return this.request.getHeader(USER_AGENT);
    }

    @Override
    public String pathInfo() {
        return this.request.getPathInfo();
    }

    @Override
    public String protocol() {
        return this.request.getProtocol();
    }

    @Override
    public String servletPath() {
        return this.request.getServletPath();
    }

    @Override
    public String contextPath() {
        return this.request.getContextPath();
    }

    @Override
    public ServletContext context() {
        return this.request.getServletContext();
    }

    @Override
    public Map<String, String> pathParams() {
        return this.pathParams;
    }

    @Override
    public String param(String name) {
        String val = this.pathParams.get(name);
        if (null != val && this.blade.enableXSS()) {
            return this.blade.xss().filter(val);
        }
        return val;
    }

    @Override
    public String param(String name, String defaultValue) {
        String val = this.pathParams.get(name);
        if (null == val) {
            val = defaultValue;
        }
        if (null != val && this.blade.enableXSS()) {
            return this.blade.xss().filter(val);
        }
        return val;
    }

    @Override
    public Integer paramAsInt(String name) {
        String value = this.param(name);
        if (StringKit.isNotBlank((String)value)) {
            return Integer.parseInt(value);
        }
        return null;
    }

    @Override
    public Long paramAsLong(String name) {
        String value = this.param(name);
        if (StringKit.isNotBlank((String)value)) {
            return Long.parseLong(value);
        }
        return null;
    }

    @Override
    public Boolean paramAsBool(String name) {
        String value = this.param(name);
        if (StringKit.isNotBlank((String)value)) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    @Override
    public String queryString() {
        return this.request.getQueryString();
    }

    @Override
    public Map<String, String> querys() {
        HashMap params = new HashMap();
        Map requestParams = this.request.getParameterMap();
        for (Map.Entry entry : requestParams.entrySet()) {
            params.put(entry.getKey(), this.join((String[])entry.getValue()));
        }
        params.putAll(this.multipartParams);
        return Collections.unmodifiableMap(params);
    }

    @Override
    public String query(String name) {
        String[] param = this.request.getParameterValues(name);
        String val = null;
        val = param != null ? this.join(param) : this.multipartParams.get(name);
        if (null != val && this.blade.enableXSS()) {
            return this.blade.xss().filter(val);
        }
        return val;
    }

    @Override
    public String query(String name, String defaultValue) {
        String[] param = this.request.getParameterValues(name);
        String val = null;
        val = param != null ? this.join(param) : this.multipartParams.get(name);
        if (null == val) {
            val = defaultValue;
        }
        if (this.blade.enableXSS()) {
            return this.blade.xss().filter(val);
        }
        return val;
    }

    @Override
    public Integer queryAsInt(String name) {
        String value = this.query(name);
        if (StringKit.isNotBlank((String)value) && StringKit.isNumber((String)value)) {
            return Integer.parseInt(value);
        }
        return null;
    }

    @Override
    public Long queryAsLong(String name) {
        String value = this.query(name);
        if (StringKit.isNotBlank((String)value) && StringKit.isNumber((String)value)) {
            return Long.parseLong(value);
        }
        return null;
    }

    @Override
    public Boolean queryAsBool(String name) {
        String value = this.query(name);
        if (StringKit.isNotBlank((String)value) && StringKit.isBoolean((String)value)) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    @Override
    public Float queryAsFloat(String name) {
        String value = this.query(name);
        if (StringKit.isNotBlank((String)value)) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Double queryAsDouble(String name) {
        String value = this.query(name);
        if (StringKit.isNotBlank((String)value)) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String method() {
        return this.request.getMethod();
    }

    @Override
    public HttpMethod httpMethod() {
        return HttpMethod.valueOf(this.request.getMethod().toUpperCase());
    }

    @Override
    public String address() {
        return this.request.getRemoteAddr();
    }

    @Override
    public Session session() {
        if (this.session == null) {
            this.session = new Session(this.request.getSession());
        }
        return this.session;
    }

    @Override
    public Session session(boolean create) {
        HttpSession httpSession;
        if (this.session == null && (httpSession = this.request.getSession(create)) != null) {
            this.session = new Session(httpSession);
        }
        return this.session;
    }

    @Override
    public void attribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    @Override
    public <T> T attribute(String name) {
        Object object = this.request.getAttribute(name);
        if (null != object) {
            return (T)object;
        }
        return null;
    }

    @Override
    public Set<String> attributes() {
        HashSet<String> attrList = new HashSet<String>();
        Enumeration attributes = this.request.getAttributeNames();
        while (attributes.hasMoreElements()) {
            attrList.add((String)attributes.nextElement());
        }
        return attrList;
    }

    @Override
    public String contentType() {
        return this.request.getContentType();
    }

    @Override
    public int port() {
        return this.request.getServerPort();
    }

    @Override
    public boolean isSecure() {
        return this.request.isSecure();
    }

    @Override
    public boolean isAjax() {
        if (this.request.getHeader("x-requested-with") == null) {
            return false;
        }
        return "XMLHttpRequest".equals(this.request.getHeader("x-requested-with"));
    }

    @Override
    public Map<String, Cookie> cookies() {
        Cookie[] servletCookies = this.request.getCookies();
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        for (Cookie c : servletCookies) {
            cookies.put(c.getName(), this.map(c));
        }
        return Collections.unmodifiableMap(cookies);
    }

    private Cookie map(Cookie servletCookie) {
        String domain;
        Cookie cookie = new Cookie(servletCookie.getName(), servletCookie.getValue());
        cookie.setMaxAge(servletCookie.getMaxAge());
        cookie.setHttpOnly(servletCookie.isHttpOnly());
        String path = servletCookie.getPath();
        if (null != path) {
            cookie.setPath(path);
        }
        if (null != (domain = servletCookie.getDomain())) {
            cookie.setDomain(domain);
        }
        cookie.setSecure(servletCookie.getSecure());
        return cookie;
    }

    @Override
    public String cookie(String name) {
        Cookie cookie = this.cookieRaw(name);
        if (null != cookie) {
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public Cookie cookieRaw(String name) {
        Cookie[] servletCookies = this.request.getCookies();
        if (servletCookies == null) {
            return null;
        }
        for (Cookie c : servletCookies) {
            if (!c.getName().equals(name)) continue;
            return this.map(c);
        }
        return null;
    }

    @Override
    public Map<String, String> headers() {
        Enumeration servletHeaders = this.request.getHeaderNames();
        HashMap<String, String> headers = new HashMap<String, String>();
        while (servletHeaders.hasMoreElements()) {
            String headerName = (String)servletHeaders.nextElement();
            headers.put(headerName, this.request.getHeader(headerName));
        }
        return headers;
    }

    @Override
    public String header(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public void encoding(String encoding) {
        try {
            this.request.setCharacterEncoding(encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setRoute(Route route) {
        this.route = route;
        this.initPathParams(route.getPath());
    }

    @Override
    public Route route() {
        return this.route;
    }

    @Override
    public void abort() {
        this.isAbort = true;
    }

    @Override
    public boolean isAbort() {
        return this.isAbort;
    }

    @Override
    public <T> T model(String slug, Class<? extends Serializable> clazz) {
        if (StringKit.isNotBlank((String)slug) && null != clazz) {
            return (T)ObjectKit.model((String)slug, clazz, this.querys());
        }
        return null;
    }

    @Override
    public FileItem[] files() {
        FileItem[] fileParts = new FileItem[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            fileParts[i] = this.files.get(i);
        }
        return fileParts;
    }

    @Override
    public Request.BodyParser body() {
        return new Request.BodyParser(){

            @Override
            public String asString() {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)ServletRequest.this.request.getInputStream()));
                    StringBuilder sb = new StringBuilder();
                    String line = reader.readLine();
                    while (line != null) {
                        sb.append(line + "\n");
                        line = reader.readLine();
                    }
                    reader.close();
                    String data = sb.toString();
                    return data;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public InputStream asInputStream() {
                try {
                    return ServletRequest.this.request.getInputStream();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public byte[] asByte() {
                try {
                    return IOKit.toByteArray((InputStream)ServletRequest.this.request.getInputStream());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
    }
}

