/*
 * Decompiled with CFR 0.152.
 */
package com.blade.web;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StaticFileFilter {
    private Set<String> prefixList;
    private Map<String, Boolean> cache;

    public StaticFileFilter(Set<String> prefixList) {
        this.prefixList = prefixList;
        this.cache = new HashMap<String, Boolean>(128);
    }

    public boolean isStatic(String path) {
        Boolean found;
        if (this.cache != null && (found = this.cache.get(path)) != null) {
            return found == Boolean.TRUE;
        }
        for (String prefix : this.prefixList) {
            if (!path.startsWith(prefix)) continue;
            if (this.cache != null) {
                this.cache.put(path, Boolean.TRUE);
            }
            return true;
        }
        if (this.cache != null) {
            this.cache.put(path, Boolean.FALSE);
        }
        return false;
    }
}

