/*
 * Decompiled with CFR 0.152.
 */
package com.blade.web;

import blade.kit.StringKit;
import blade.kit.SystemKit;
import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import com.blade.Blade;
import com.blade.Bootstrap;
import com.blade.context.BladeWebContext;
import com.blade.ioc.IocApplication;
import com.blade.route.RouteBuilder;
import com.blade.web.BladeBanner;
import com.blade.web.DispatchKit;
import com.blade.web.DispatcherHandler;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = -2607425162473178733L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DispatcherServlet.class);
    private Blade blade = Blade.me();
    private Bootstrap bootstrap;
    private IocApplication iocApplication;
    private ServletContext servletContext;
    private DispatcherHandler dispatcherHandler;

    public DispatcherServlet() {
    }

    public DispatcherServlet(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
        this.blade.init();
    }

    public void init(ServletConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
        if (!this.blade.isInit()) {
            LOGGER.info("DispatcherServlet start ...");
            LOGGER.info("jdk.version = {}", new Object[]{SystemKit.getJavaInfo().getVersion()});
            LOGGER.info("user.dir = {}", new Object[]{System.getProperty("user.dir")});
            LOGGER.info("java.io.tmpdir = {}", new Object[]{System.getProperty("java.io.tmpdir")});
            LOGGER.info("user.timezone = {}", new Object[]{System.getProperty("user.timezone")});
            LOGGER.info("file.encoding = {}", new Object[]{System.getProperty("file.encoding")});
            long initStart = System.currentTimeMillis();
            this.blade.webRoot(DispatchKit.getWebroot(this.servletContext).getPath());
            BladeWebContext.setContext(this.servletContext);
            LOGGER.info("blade.webroot = {}", new Object[]{this.blade.webRoot()});
            this.blade.config().init();
            this.bootstrap = this.blade.bootstrap();
            if (null == this.bootstrap) {
                String bootStrapClassName = config.getInitParameter("bootstrap");
                this.bootstrap = StringKit.isNotBlank((String)bootStrapClassName) ? this.getBootstrap(bootStrapClassName) : new Bootstrap(){

                    @Override
                    public void init(Blade blade) {
                    }
                };
                this.blade.app(this.bootstrap);
            }
            this.bootstrap.init(this.blade);
            LOGGER.info("blade.isDev = {}", new Object[]{this.blade.isDev()});
            new RouteBuilder(this.blade).building();
            this.iocApplication = new IocApplication(this.blade);
            this.iocApplication.init();
            this.blade.init();
            this.bootstrap.contextInitialized(this.blade);
            this.dispatcherHandler = new DispatcherHandler(this.servletContext, this.blade.routers());
            new BladeBanner().print();
            LOGGER.info("DispatcherServlet initialize successfully, Time elapsed: {} ms.", new Object[]{System.currentTimeMillis() - initStart});
        }
    }

    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        httpRequest.setCharacterEncoding(this.blade.encoding());
        httpResponse.setCharacterEncoding(this.blade.encoding());
        if (!this.blade.httpCache()) {
            DispatchKit.setNoCache(httpResponse);
        }
        this.dispatcherHandler.handle(httpRequest, httpResponse);
    }

    public void destroy() {
        super.destroy();
        if (null != this.iocApplication) {
            this.iocApplication.destroy();
        }
    }

    private Bootstrap getBootstrap(String botstrapClassName) throws ServletException {
        Bootstrap bootstrapClass;
        block4: {
            bootstrapClass = null;
            try {
                if (null != botstrapClassName) {
                    Class<?> applicationClass = Class.forName(botstrapClassName);
                    if (null != applicationClass) {
                        bootstrapClass = (Bootstrap)applicationClass.newInstance();
                    }
                    break block4;
                }
                throw new ServletException("bootstrapClass is null !");
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        return bootstrapClass;
    }
}

