/*
 * Decompiled with CFR 0.152.
 */
package com.blade.view.handle;

import blade.kit.reflect.ReflectKit;
import com.blade.ioc.Ioc;
import com.blade.route.Route;
import com.blade.route.annotation.PathVariable;
import com.blade.route.annotation.RequestParam;
import com.blade.view.ModelAndView;
import com.blade.view.ModelMap;
import com.blade.web.DispatchKit;
import com.blade.web.http.Request;
import com.blade.web.http.Response;
import com.blade.web.http.wrapper.Session;
import com.blade.web.multipart.FileItem;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class RouteViewHandler {
    private Ioc ioc;

    public RouteViewHandler(Ioc ioc) {
        this.ioc = ioc;
    }

    private Object getPathParam(Class<?> parameterType, String val, Request request) {
        Object result = null;
        if (parameterType.equals(String.class)) {
            result = request.param(val);
        } else if (parameterType.equals(Integer.class) || parameterType.equals(Integer.TYPE)) {
            result = request.paramAsInt(val);
        } else if (parameterType.equals(Boolean.class) || parameterType.equals(Boolean.TYPE)) {
            result = request.paramAsBool(val);
        } else if (parameterType.equals(Long.class) || parameterType.equals(Long.TYPE)) {
            result = request.paramAsLong(val);
        }
        return result;
    }

    private Object getRequestParam(Class<?> parameterType, String val, String defaultValue, Request request) {
        Object result = null;
        if (parameterType.equals(String.class)) {
            String value = request.query(val);
            result = null == value ? defaultValue : value;
        } else if (parameterType.equals(Integer.class) || parameterType.equals(Integer.TYPE)) {
            Integer value = request.queryAsInt(val);
            result = null == value ? Integer.valueOf(defaultValue) : value;
        } else if (parameterType.equals(Boolean.class) || parameterType.equals(Boolean.TYPE)) {
            Boolean value = request.queryAsBool(val);
            result = null == value ? Boolean.valueOf(defaultValue) : value;
        } else if (parameterType.equals(Long.class) || parameterType.equals(Long.TYPE)) {
            Long value = request.queryAsLong(val);
            result = null == value ? Long.valueOf(defaultValue) : value;
        }
        return result;
    }

    public Object[] getArgs(Request request, Response response, Method actionMethod) {
        Annotation[][] parameterAnnotations = actionMethod.getParameterAnnotations();
        Class<?>[] parameterTypes = actionMethod.getParameterTypes();
        int len = parameterTypes.length;
        Object[] args = new Object[len];
        actionMethod.setAccessible(true);
        int i = 0;
        if (parameterAnnotations.length > 0) {
            for (Annotation[] annotations : parameterAnnotations) {
                Class<?> parameterType = parameterTypes[i];
                for (Annotation annotation : annotations) {
                    Object value;
                    String val;
                    Class<? extends Annotation> anType = annotation.annotationType();
                    if (anType.equals(PathVariable.class)) {
                        PathVariable pathVariable = (PathVariable)annotation;
                        val = pathVariable.value();
                        args[i] = value = this.getPathParam(parameterType, val, request);
                        continue;
                    }
                    if (!anType.equals(RequestParam.class)) continue;
                    RequestParam requestParam = (RequestParam)annotation;
                    val = requestParam.value();
                    args[i] = value = this.getRequestParam(parameterType, val, requestParam.defaultValue(), request);
                }
                ++i;
            }
        }
        for (i = 0; i < len; ++i) {
            FileItem[] fileItems;
            Class<?> paramTypeClazz = parameterTypes[i];
            if (paramTypeClazz.equals(Request.class)) {
                args[i] = request;
                continue;
            }
            if (paramTypeClazz.equals(Response.class)) {
                args[i] = response;
                continue;
            }
            if (paramTypeClazz.equals(Session.class)) {
                args[i] = request.session();
                continue;
            }
            if (paramTypeClazz.equals(ModelMap.class)) {
                args[i] = new ModelMap(request);
                continue;
            }
            if (paramTypeClazz.equals(HttpServletRequest.class)) {
                args[i] = request.raw();
                continue;
            }
            if (paramTypeClazz.equals(HttpServletResponse.class)) {
                args[i] = response.raw();
                continue;
            }
            if (paramTypeClazz.equals(HttpSession.class)) {
                args[i] = request.raw().getSession();
                continue;
            }
            if (!paramTypeClazz.equals(FileItem.class) || null == (fileItems = request.files()) || fileItems.length <= 0) continue;
            args[i] = fileItems[0];
        }
        return args;
    }

    public void handle(Request request, Response response, Route route) {
        Method actionMethod = route.getAction();
        Object target = route.getTarget();
        int len = actionMethod.getParameterTypes().length;
        try {
            Object returnParam = null;
            if (len > 0) {
                Object[] args = this.getArgs(request, response, actionMethod);
                returnParam = ReflectKit.invokeMehod((Object)target, (Method)actionMethod, (Object[])args);
            } else {
                returnParam = ReflectKit.invokeMehod((Object)target, (Method)actionMethod, (Object[])new Object[0]);
            }
            if (null != returnParam) {
                Class<?> returnType = returnParam.getClass();
                if (returnType == String.class) {
                    response.render(returnParam.toString());
                } else if (returnType == ModelAndView.class) {
                    ModelAndView modelAndView = (ModelAndView)returnParam;
                    response.render(modelAndView);
                }
            }
        }
        catch (Exception e) {
            request.abort();
            DispatchKit.printError(e, 500, response);
        }
    }

    public boolean intercept(Request request, Response response, Route route) {
        Method actionMethod = route.getAction();
        Object target = route.getTarget();
        if (null == target) {
            Class<?> clazz = route.getAction().getDeclaringClass();
            target = this.ioc.getBean(clazz);
            route.setTarget(target);
        }
        int len = actionMethod.getParameterTypes().length;
        actionMethod.setAccessible(true);
        try {
            Class<?> returnType;
            Object returnParam = null;
            if (len > 0) {
                Object[] args = this.getArgs(request, response, actionMethod);
                returnParam = ReflectKit.invokeMehod((Object)target, (Method)actionMethod, (Object[])args);
            } else {
                returnParam = ReflectKit.invokeMehod((Object)target, (Method)actionMethod, (Object[])new Object[0]);
            }
            if (null != returnParam && ((returnType = returnParam.getClass()) == Boolean.class || returnType == Boolean.TYPE)) {
                return (Boolean)returnParam;
            }
            return true;
        }
        catch (Exception e) {
            request.abort();
            DispatchKit.printError(e, 500, response);
            return false;
        }
    }
}

