/*
 * Decompiled with CFR 0.152.
 */
package com.blade.loader;

import blade.kit.Assert;
import blade.kit.CollectionKit;
import blade.kit.StringKit;
import blade.kit.config.Config;
import com.blade.loader.BladeConfig;
import java.util.Map;

public final class Configurator {
    public static void init(BladeConfig bladeConfig, Config config) {
        Map configMap;
        Assert.notNull((Object)bladeConfig);
        Assert.notNull((Object)config);
        Boolean dev = config.getBoolean("blade.dev");
        Boolean httpCache = config.getBoolean("blade.http.cache");
        Boolean httpXss = config.getBoolean("blade.http.xss");
        String httpEncoding = config.getString("blade.http.encoding");
        String httpFilters = config.getString("blade.http.filters");
        String basePackage = config.getString("blade.basepackage");
        String iocPackage = config.getString("blade.ioc");
        String view500 = config.getString("blade.view.500");
        String view404 = config.getString("blade.view.404");
        if (null != dev) {
            bladeConfig.setDev(dev);
        }
        if (null != httpCache) {
            bladeConfig.setHttpCache(httpCache);
        }
        if (StringKit.isNotBlank((String)httpEncoding)) {
            bladeConfig.setEncoding(httpEncoding);
        }
        if (StringKit.isNotBlank((String)iocPackage)) {
            bladeConfig.addIocPackages(iocPackage);
        }
        if (null != httpXss) {
            bladeConfig.setHttpXss(httpXss);
        }
        if (StringKit.isNotBlank((String)httpFilters)) {
            bladeConfig.setStaticFolders(httpFilters.split(","));
        }
        if (StringKit.isNotBlank((String)view404)) {
            bladeConfig.setView404(view404);
        }
        if (StringKit.isNotBlank((String)view500)) {
            bladeConfig.setView500(view500);
        }
        if (StringKit.isNotBlank((String)basePackage)) {
            bladeConfig.setBasePackage(basePackage);
            bladeConfig.addIocPackages(basePackage + ".service.*");
            bladeConfig.addRoutePackages(basePackage + ".controller");
            bladeConfig.setInterceptorPackage(basePackage + ".interceptor");
        }
        if (CollectionKit.isNotEmpty((Map)(configMap = config.getConfigMap()))) {
            bladeConfig.setConfigMap(configMap);
        }
    }
}

