/*
 * Decompiled with CFR 0.152.
 */
package com.blade.loader;

import blade.kit.PatternKit;
import blade.kit.config.Config;
import blade.kit.config.loader.ConfigLoader;
import com.blade.loader.Configurator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BladeConfig {
    private Map<String, String> configMap;
    private Set<String> routePackages = new HashSet<String>();
    private Set<String> iocPackages = new HashSet<String>();
    private Set<String> staticFolders = new HashSet<String>();
    private String basePackage;
    private String interceptorPackage;
    private String encoding = "utf-8";
    private String webRoot;
    private String view404;
    private String view500;
    private boolean isDev = true;
    private boolean httpXss = false;
    private boolean httpCache = false;
    private boolean configInit = false;

    public BladeConfig() {
        this.staticFolders.add("/public");
        this.staticFolders.add("/assets");
        this.staticFolders.add("/static");
    }

    public void init() {
        if (!this.configInit) {
            try {
                Config config = ConfigLoader.load((String)"blade.properties");
                if (null != config) {
                    Configurator.init(this, config);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Map<String, String> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<String, String> configMap) {
        this.configMap = configMap;
    }

    public String get(String key) {
        return this.configMap.get(key);
    }

    public Integer getAsInt(String key) {
        String val = this.get(key);
        if (null != val && PatternKit.isNumber((String)val)) {
            return Integer.valueOf(val);
        }
        return null;
    }

    public Long getAsLong(String key) {
        String val = this.get(key);
        if (null != val && PatternKit.isNumber((String)val)) {
            return Long.valueOf(val);
        }
        return null;
    }

    public Boolean getAsBoolean(String key) {
        String val = this.get(key);
        if (null != val) {
            return Boolean.valueOf(val);
        }
        return null;
    }

    public Double getAsDouble(String key) {
        String val = this.get(key);
        if (null != val) {
            return Double.valueOf(val);
        }
        return null;
    }

    public Float getAsFloat(String key) {
        String val = this.get(key);
        if (null != val) {
            return Float.valueOf(val);
        }
        return null;
    }

    public String[] getRoutePackages() {
        String[] routeArr = new String[this.routePackages.size()];
        return this.routePackages.toArray(routeArr);
    }

    public void addRoutePackages(String ... packages) {
        if (null != packages && packages.length > 0) {
            this.routePackages.addAll(Arrays.asList(packages));
        }
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String[] getIocPackages() {
        String[] iocArr = new String[this.iocPackages.size()];
        return this.iocPackages.toArray(iocArr);
    }

    public void addIocPackages(String ... packages) {
        if (null != packages && packages.length > 0) {
            this.iocPackages.addAll(Arrays.asList(packages));
        }
    }

    public String getInterceptorPackage() {
        return this.interceptorPackage;
    }

    public void setInterceptorPackage(String interceptorPackage) {
        this.interceptorPackage = interceptorPackage;
    }

    public Set<String> getStaticFolders() {
        return this.staticFolders;
    }

    public void setStaticFolders(String ... packages) {
        this.staticFolders.addAll(Arrays.asList(packages));
    }

    public String getView404() {
        return this.view404;
    }

    public void setView404(String view404) {
        this.view404 = view404;
    }

    public String getView500() {
        return this.view500;
    }

    public void setView500(String view500) {
        this.view500 = view500;
    }

    public String getWebRoot() {
        return this.webRoot;
    }

    public void setWebRoot(String webRoot) {
        this.webRoot = webRoot;
    }

    public boolean isDev() {
        return this.isDev;
    }

    public void setDev(boolean isDev) {
        this.isDev = isDev;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isHttpXss() {
        return this.httpXss;
    }

    public void setHttpXss(boolean httpXss) {
        this.httpXss = httpXss;
    }

    public boolean isHttpCache() {
        return this.httpCache;
    }

    public void setHttpCache(boolean httpCache) {
        this.httpCache = httpCache;
    }
}

