/*
 * Decompiled with CFR 0.152.
 */
package com.blade.ioc.loader;

import blade.kit.resource.ClassPathClassReader;
import blade.kit.resource.ClassReader;
import com.blade.ioc.SimpleIoc;
import com.blade.ioc.annotation.Component;
import com.blade.ioc.loader.IocLoader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class IocAnnotationLoader
implements IocLoader {
    private Collection<Class<?>> classes;
    private ClassReader classReader = new ClassPathClassReader();

    public IocAnnotationLoader(String ... packageNames) {
        ArrayList<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>(1);
        annotations.add(Component.class);
        this.classes = this.finder(Arrays.asList(packageNames), annotations, true);
    }

    private Collection<Class<?>> finder(List<String> packageNames, List<Class<? extends Annotation>> annotations, boolean recursive) {
        ArrayList classes = new ArrayList();
        for (String packageName : packageNames) {
            for (Class<? extends Annotation> annotation : annotations) {
                classes.addAll(this.classReader.getClassByAnnotation(packageName, annotation, recursive));
            }
        }
        return classes;
    }

    public IocAnnotationLoader(Collection<Class<?>> classes) {
        this.classes = classes;
    }

    @Override
    public void load(SimpleIoc ioc) {
        for (Class<?> cls : this.classes) {
            Component anno = cls.getAnnotation(Component.class);
            if (anno == null) continue;
            String name = anno.value().equals("") ? cls.getName() : anno.value();
            ioc.addBean(name, cls, true);
        }
        this.classes = null;
    }
}

