/*
 * Decompiled with CFR 0.152.
 */
package com.blade.context;

import com.blade.web.http.Request;
import com.blade.web.http.Response;
import com.blade.web.http.wrapper.Session;
import javax.servlet.ServletContext;

public class BladeWebContext {
    private static ThreadLocal<BladeWebContext> ctx = new ThreadLocal();
    private ServletContext context;
    private Request request;
    private Response response;

    private BladeWebContext() {
    }

    public static BladeWebContext me() {
        return ctx.get();
    }

    public static void setContext(ServletContext context) {
        BladeWebContext bladeWebContext = new BladeWebContext();
        bladeWebContext.context = context;
        ctx.set(bladeWebContext);
    }

    public static void setContext(ServletContext context, Request request, Response response) {
        BladeWebContext bladeWebContext = new BladeWebContext();
        bladeWebContext.context = context;
        bladeWebContext.request = request;
        bladeWebContext.response = response;
        ctx.set(bladeWebContext);
    }

    public static void remove() {
        ctx.remove();
    }

    public static Request request() {
        return BladeWebContext.me().request;
    }

    public static Response response() {
        return BladeWebContext.me().response;
    }

    public static Session session() {
        return BladeWebContext.request().session();
    }

    public static ServletContext servletContext() {
        return BladeWebContext.me().context;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }
}

