/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.util.SimpleStringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.IndexNameBuilder;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.elasticsearch.client.ClientUtil;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.client.ElasticSearchRestClient;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.frameworkset.elasticsearch.client.SliceScroll;
import org.frameworkset.elasticsearch.entity.AggHit;
import org.frameworkset.elasticsearch.entity.ESAggDatas;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.entity.ESIndice;
import org.frameworkset.elasticsearch.entity.IndexField;
import org.frameworkset.elasticsearch.entity.MGetDocs;
import org.frameworkset.elasticsearch.entity.MapRestResponse;
import org.frameworkset.elasticsearch.entity.MapSearchHit;
import org.frameworkset.elasticsearch.entity.RestResponse;
import org.frameworkset.elasticsearch.entity.SearchHit;
import org.frameworkset.elasticsearch.entity.sql.ColumnMeta;
import org.frameworkset.elasticsearch.entity.sql.SQLRestResponse;
import org.frameworkset.elasticsearch.entity.sql.SQLRestResponseHandler;
import org.frameworkset.elasticsearch.entity.sql.SQLResult;
import org.frameworkset.elasticsearch.entity.suggest.CompleteElasticSearchResponseHandler;
import org.frameworkset.elasticsearch.entity.suggest.CompleteRestResponse;
import org.frameworkset.elasticsearch.entity.suggest.ElasticSearchPhraseResponseHandler;
import org.frameworkset.elasticsearch.entity.suggest.ElasticSearchTermResponseHandler;
import org.frameworkset.elasticsearch.entity.suggest.PhraseRestResponse;
import org.frameworkset.elasticsearch.entity.suggest.TermRestResponse;
import org.frameworkset.elasticsearch.handler.ESAggBucketHandle;
import org.frameworkset.elasticsearch.handler.ESMapResponseHandler;
import org.frameworkset.elasticsearch.handler.ESStringResponseHandler;
import org.frameworkset.elasticsearch.handler.ElasticSearchMapResponseHandler;
import org.frameworkset.elasticsearch.handler.ElasticSearchResponseHandler;
import org.frameworkset.elasticsearch.handler.GetDocumentHitResponseHandler;
import org.frameworkset.elasticsearch.handler.GetDocumentResponseHandler;
import org.frameworkset.elasticsearch.handler.GetDocumentSourceResponseHandler;
import org.frameworkset.elasticsearch.handler.MGetDocumentsSourceResponseHandler;
import org.frameworkset.elasticsearch.scroll.DefualtScrollHandler;
import org.frameworkset.elasticsearch.scroll.ParallelSliceScrollResult;
import org.frameworkset.elasticsearch.scroll.ScrollHandler;
import org.frameworkset.elasticsearch.scroll.SliceScrollResultInf;
import org.frameworkset.elasticsearch.serial.ESTypeReferences;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.json.JsonTypeReference;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientUtil
extends ClientUtil {
    private static Logger logger = LoggerFactory.getLogger(RestClientUtil.class);
    protected ElasticSearchRestClient client;
    protected StringBuilder bulkBuilder;
    protected IndexNameBuilder indexNameBuilder;
    protected String[] monitorIndices = new String[]{".monitoring*", ".triggered_watches", ".watcher-history*", ".ml*"};
    protected String monitorIndicesString = ".monitoring*,.triggered_watches,.watcher-history*,.ml*";

    public RestClientUtil(ElasticSearchClient client, IndexNameBuilder indexNameBuilder) {
        this.client = (ElasticSearchRestClient)client;
        this.indexNameBuilder = indexNameBuilder;
    }

    @Override
    public List<IndexField> getIndexMappingFields(String index, final String indexType) throws ElasticSearchException {
        try {
            final ArrayList<IndexField> fields = new ArrayList<IndexField>();
            this.getIndexMapping(index, false, new ResponseHandler<Void>(){

                public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        Map map = (Map)SimpleStringUtil.json2ObjectWithType((InputStream)entity.getContent(), (JsonTypeReference)new JsonTypeReference<Map<String, Object>>(){});
                        Iterator entries = map.entrySet().iterator();
                        if (entries.hasNext()) {
                            Map.Entry entry = entries.next();
                            Map mapping = (Map)entry.getValue();
                            Map typeProperties = (Map)((Map)mapping.get("mappings")).get(indexType);
                            Map properties = (Map)typeProperties.get("properties");
                            for (Map.Entry<String, Object> entry2 : properties.entrySet()) {
                                IndexField indexField = BuildTool.buildIndexField(entry2, fields, null);
                            }
                        }
                        return null;
                    }
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        throw new ElasticSearchException("Unexpected response : " + EntityUtils.toString((HttpEntity)entity), status);
                    }
                    throw new ElasticSearchException("Unexpected response status: " + status, status);
                }
            });
            return fields;
        }
        catch (ElasticSearchException e) {
            return (List)ResultUtil.hand404HttpRuntimeException(e, Object.class, 4);
        }
    }

    @Override
    public String updateDocuments(String indexName, String indexType, String updateTemplate, List<?> beans) throws ElasticSearchException {
        return null;
    }

    @Override
    public String updateDocuments(String indexName, String indexType, String updateTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String executeRequest(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String getDynamicIndexName(String indexName) {
        return this.indexNameBuilder.getIndexName(indexName);
    }

    @Override
    public String addDateDocument(String indexName, String indexType, Object bean) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, bean);
    }

    @Override
    public String addDateDocument(String indexName, String indexType, Object bean, String refreshOption) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, bean, refreshOption);
    }

    @Override
    public String addDateDocumentWithId(String indexName, String indexType, Object bean, Object docId) throws ElasticSearchException {
        return this.addDocumentWithId(this.indexNameBuilder.getIndexName(indexName), indexType, bean, docId);
    }

    @Override
    public String addDateDocumentWithId(String indexName, String indexType, Object bean, Object docId, Object parentId) throws ElasticSearchException {
        return this.addDocumentWithId(this.indexNameBuilder.getIndexName(indexName), indexType, bean, docId, parentId);
    }

    @Override
    public String addDateDocumentWithParentId(String indexName, String indexType, Object bean, Object parentId) throws ElasticSearchException {
        return this.addDocumentWithId(this.indexNameBuilder.getIndexName(indexName), indexType, bean, null, parentId);
    }

    @Override
    public String addDateDocument(String indexName, String indexType, Object bean, Object docId, String refreshOption) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, bean, docId, refreshOption);
    }

    @Override
    public String addDateDocument(String indexName, String indexType, Object bean, Object docId, Object parentId, String refreshOption) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, bean, docId, parentId, refreshOption);
    }

    @Override
    public String addDateDocumentWithParentId(String indexName, String indexType, Object bean, Object parentId, String refreshOption) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, bean, null, parentId, refreshOption);
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, List<?> beans) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, beans);
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, beans, refreshOption);
    }

    @Override
    public String addDocuments(String indexName, String indexType, List<?> beans) throws ElasticSearchException {
        return this.addDocuments(indexName, indexType, beans, null);
    }

    @Override
    public String addDocuments(String indexName, String indexType, List<?> beans, String refreshOption) throws ElasticSearchException {
        if (beans == null || beans.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        for (Object bean : beans) {
            try {
                BuildTool.evalBuilk((Writer)writer, indexName, indexType, bean, "index");
            }
            catch (IOException e) {
                throw new ElasticSearchException(e);
            }
        }
        writer.flush();
        if (refreshOption == null) {
            return this.client.executeHttp("_bulk", builder.toString(), "post");
        }
        return this.client.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
    }

    @Override
    public String addDateDocumentsWithIdKey(String indexName, String indexType, List<Map> beans, String docIdKey) throws ElasticSearchException {
        return this.addDocumentsWithIdKey(this.indexNameBuilder.getIndexName(indexName), indexType, beans, docIdKey);
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, List<Map> beans, String docIdKey, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, beans, docIdKey, refreshOption);
    }

    @Override
    public String addDocuments(String indexName, String indexType, List<Map> beans, String docIdKey, String refreshOption) throws ElasticSearchException {
        if (beans == null || beans.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        for (Map bean : beans) {
            try {
                BuildTool.evalBuilk((Writer)writer, indexName, indexType, bean, "index", docIdKey, null);
            }
            catch (IOException e) {
                throw new ElasticSearchException(e);
            }
        }
        writer.flush();
        if (refreshOption == null) {
            return this.client.executeHttp("_bulk", builder.toString(), "post");
        }
        return this.client.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
    }

    @Override
    public String addDocumentsWithIdKey(String indexName, String indexType, List<Map> beans, String docIdKey) throws ElasticSearchException {
        return this.addDocuments(indexName, indexType, beans, docIdKey, (String)null);
    }

    @Override
    public String addDateDocumentsWithIdKey(String indexName, String indexType, List<Map> beans, String docIdKey, String parentIdKey) throws ElasticSearchException {
        return this.addDocumentsWithIdKey(this.indexNameBuilder.getIndexName(indexName), indexType, beans, docIdKey, parentIdKey);
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, List<Map> beans, String docIdKey, String parentIdKey, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, beans, docIdKey, parentIdKey, refreshOption);
    }

    @Override
    public String addDocuments(String indexName, String indexType, List<Map> beans, String docIdKey, String parentIdKey, String refreshOption) throws ElasticSearchException {
        if (beans == null || beans.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        for (Map bean : beans) {
            try {
                BuildTool.evalBuilk((Writer)writer, indexName, indexType, bean, "index", docIdKey, parentIdKey);
            }
            catch (IOException e) {
                throw new ElasticSearchException(e);
            }
        }
        writer.flush();
        if (refreshOption == null) {
            return this.client.executeHttp("_bulk", builder.toString(), "post");
        }
        return this.client.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
    }

    @Override
    public String addDocumentsWithIdKey(String indexName, String indexType, List<Map> beans, String docIdKey, String parentIdKey) throws ElasticSearchException {
        return this.addDocuments(indexName, indexType, beans, docIdKey, parentIdKey, null);
    }

    @Override
    public String addDocument(String indexName, String indexType, Object bean) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, bean, null);
    }

    @Override
    public String addDocument(String indexName, String indexType, Object bean, String refreshOption) throws ElasticSearchException {
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(bean.getClass());
        Object id = BuildTool.getId(bean, beanInfo);
        Object parentId = BuildTool.getParentId(bean, beanInfo);
        return this.addDocument(indexName, indexType, bean, id, parentId, refreshOption);
    }

    @Override
    public String addDocumentWithId(String indexName, String indexType, Object bean, Object docId) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, bean, docId, null);
    }

    @Override
    public String addDocumentWithId(String indexName, String indexType, Object bean, Object docId, Object parentId) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, bean, docId, parentId, null);
    }

    @Override
    public String addDocumentWithParentId(String indexName, String indexType, Object bean, Object parentId) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, bean, null, parentId, null);
    }

    @Override
    public String addDocument(String indexName, String indexType, Object bean, Object docId, String refreshOption) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, bean, docId, null, refreshOption);
    }

    @Override
    public String addDocument(String indexName, String indexType, Object bean, Object docId, Object parentId, String refreshOption) throws ElasticSearchException {
        ClassUtil.ClassInfo beanInfo = ClassUtil.getClassInfo(bean.getClass());
        Object routing = BuildTool.getRouting(bean, beanInfo);
        return this.addDocument(indexName, indexType, bean, docId, parentId, routing, refreshOption);
    }

    public String addDocument(String indexName, String indexType, Object bean, Object docId, Object parentId, Object routing, String refreshOption) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        Object id = docId;
        builder.append(indexName).append("/").append(indexType);
        if (id != null) {
            builder.append("/").append(id);
        }
        if (refreshOption != null) {
            builder.append("?").append(refreshOption);
            if (parentId != null) {
                builder.append("&parent=").append(parentId);
            }
            if (routing != null) {
                builder.append("&routing=").append(routing);
            }
        } else if (parentId != null) {
            builder.append("?parent=").append(parentId);
            if (routing != null) {
                builder.append("&routing=").append(routing);
            }
        } else if (routing != null) {
            builder.append("?routing=").append(routing);
        }
        String path = builder.toString();
        builder = null;
        path = this.client.executeHttp(path, SerialUtil.object2json(bean), "post");
        return path;
    }

    @Override
    public String addDocumentWithParentId(String indexName, String indexType, Object bean, Object parentId, String refreshOption) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, bean, null, parentId, refreshOption);
    }

    @Override
    public String updateDocuments(String indexName, String indexType, List<?> beans) throws ElasticSearchException {
        return this.updateDocuments(indexName, indexType, beans, null);
    }

    @Override
    public String updateDocuments(String indexName, String indexType, List<?> beans, String refreshOption) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        for (Object bean : beans) {
            try {
                BuildTool.evalBuilk((Writer)writer, indexName, indexType, bean, "update");
            }
            catch (IOException e) {
                throw new ElasticSearchException(e);
            }
        }
        writer.flush();
        if (refreshOption != null) {
            return this.client.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
        }
        return this.client.executeHttp("_bulk", builder.toString(), "post");
    }

    @Override
    public String updateDocumentsWithIdKey(String indexName, String indexType, List<Map> beans, String docIdKey) throws ElasticSearchException {
        return this.updateDocuments(indexName, indexType, beans, docIdKey, (String)null);
    }

    @Override
    public String updateDocumentsWithIdKey(String indexName, String indexType, List<Map> beans, String docIdKey, String parentIdKey) throws ElasticSearchException {
        return this.updateDocuments(indexName, indexType, beans, docIdKey, parentIdKey);
    }

    @Override
    public String updateDocuments(String indexName, String indexType, List<Map> beans, String docIdKey, String refreshOption) throws ElasticSearchException {
        return this.updateDocuments(indexName, indexType, beans, docIdKey, null, refreshOption);
    }

    @Override
    public String updateDocuments(String indexName, String indexType, List<Map> beans, String docIdKey, String parentIdKey, String refreshOption) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        for (Map bean : beans) {
            try {
                BuildTool.evalBuilk((Writer)writer, indexName, indexType, bean, "update", docIdKey, parentIdKey);
            }
            catch (IOException e) {
                throw new ElasticSearchException(e);
            }
        }
        writer.flush();
        if (refreshOption != null) {
            return this.client.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
        }
        return this.client.executeHttp("_bulk", builder.toString(), "post");
    }

    @Override
    public String addDocument(String indexName, String indexType, String addTemplate, Object bean) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDocument(String indexName, String indexType, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDateDocument(String indexName, String indexType, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDateDocument(String indexName, String indexType, String addTemplate, Object bean) throws ElasticSearchException {
        return null;
    }

    @Override
    public String executeRequest(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public Object executeRequest(String path) throws ElasticSearchException {
        return this.executeRequest(path, null);
    }

    @Override
    public String deleteDocuments(String indexName, String indexType, String ... ids) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        for (String id : ids) {
            builder.append("{ \"delete\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\", \"_id\" : \"").append(id).append("\" } }\n");
        }
        return this.client.executeHttp("_bulk", builder.toString(), "post");
    }

    @Override
    public String deleteDocumentsWithrefreshOption(String indexName, String indexType, String refreshOption, String ... ids) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        for (String id : ids) {
            builder.append("{ \"delete\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\", \"_id\" : \"").append(id).append("\" } }\n");
        }
        return this.client.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
    }

    @Override
    public String deleteByQuery(String path, String entity) throws ElasticSearchException {
        return this.client.executeHttp(path, entity, "post");
    }

    @Override
    public String deleteByQuery(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String deleteByQuery(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String deleteTempate(String template) throws ElasticSearchException {
        try {
            return this.client.executeHttp("/_template/" + template, "delete");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 8);
        }
    }

    @Override
    public String getTempate(String template) throws ElasticSearchException {
        try {
            return this.client.executeHttp("/_template/" + template, "get");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 3);
        }
    }

    @Override
    public String getTempate() throws ElasticSearchException {
        return this.client.executeHttp("/_template", "get");
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, String addTemplate, List<?> beans) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDocuments(String indexName, String indexType, String addTemplate, List<?> beans) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDocuments(String indexName, String indexType, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String getDocument(String indexName, String indexType, String documentId, Map<String, Object> options) throws ElasticSearchException {
        try {
            return this.client.executeHttp(BuildTool.buildGetDocumentRequest(indexName, indexType, documentId, options), "get");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 0);
        }
    }

    @Override
    public String getDocumentByPath(String path) throws ElasticSearchException {
        try {
            return this.client.executeHttp(path, "get");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 0);
        }
    }

    @Override
    public String getDocumentSource(String path) throws ElasticSearchException {
        try {
            return this.client.executeHttp(path, "get");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 0);
        }
    }

    @Override
    public <T> T getDocumentByPath(String path, Class<T> beanType) throws ElasticSearchException {
        try {
            SearchHit searchResult = this.client.executeRequest(path, null, new GetDocumentResponseHandler(beanType), "get");
            return ResultUtil.buildObject(searchResult, beanType);
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, beanType, 0);
        }
    }

    @Override
    public <T> T getDocumentSource(String path, Class<T> beanType) throws ElasticSearchException {
        try {
            Object searchResult = this.client.executeRequest(path, null, new GetDocumentSourceResponseHandler(beanType), "get");
            return searchResult;
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, beanType, 0);
        }
    }

    @Override
    public String getDocument(String indexName, String indexType, String documentId) throws ElasticSearchException {
        return this.getDocument(indexName, indexType, documentId, (Map<String, Object>)null);
    }

    @Override
    public <T> T getDocument(String indexName, String indexType, String documentId, Class<T> beanType) throws ElasticSearchException {
        return this.getDocument(indexName, indexType, documentId, null, beanType);
    }

    @Override
    public <T> T getDocument(String indexName, String indexType, String documentId, Map<String, Object> options, Class<T> beanType) throws ElasticSearchException {
        try {
            SearchHit searchResult = this.client.executeRequest(BuildTool.buildGetDocumentRequest(indexName, indexType, documentId, options), null, new GetDocumentResponseHandler(beanType), "get");
            return ResultUtil.buildObject(searchResult, beanType);
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, beanType, 0);
        }
    }

    @Override
    public <T> List<T> mgetDocuments(String path, String entity, Class<T> type) throws ElasticSearchException {
        MGetDocs searchResult = this.client.executeRequest(path, entity, new MGetDocumentsSourceResponseHandler((Class)type), "post");
        return ResultUtil.buildObjects(searchResult, type);
    }

    @Override
    public <T> List<T> mgetDocuments(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> List<T> mgetDocuments(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public MapSearchHit getDocumentHit(String indexName, String indexType, String documentId, Map<String, Object> options) throws ElasticSearchException {
        try {
            MapSearchHit searchResult = this.client.executeRequest(BuildTool.buildGetDocumentRequest(indexName, indexType, documentId, options), null, new GetDocumentHitResponseHandler(), "get");
            return searchResult;
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, MapSearchHit.class, 0);
        }
    }

    @Override
    public MapSearchHit getDocumentHit(String indexName, String indexType, String documentId) throws ElasticSearchException {
        return this.getDocumentHit(indexName, indexType, documentId, null);
    }

    @Override
    public String deleteDocument(String indexName, String indexType, String id) throws ElasticSearchException {
        try {
            return this.client.executeHttp(indexName + "/" + indexType + "/" + id, "delete");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 2);
        }
    }

    @Override
    public String deleteDocument(String indexName, String indexType, String id, String refreshOption) throws ElasticSearchException {
        try {
            return this.client.executeHttp(indexName + "/" + indexType + "/" + id + "?" + refreshOption, "delete");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 2);
        }
    }

    @Override
    public String executeRequest(String path, String entity) throws ElasticSearchException {
        return this.client.executeRequest(path, entity);
    }

    @Override
    public <T> T executeRequest(String path, String entity, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.client.executeRequest(path, entity, responseHandler);
    }

    @Override
    public <T> List<T> sql(Class<T> beanType, String entity, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> List<T> sql(Class<T> beanType, String entity, Object bean) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> List<T> sql(Class<T> beanType, String entity) throws ElasticSearchException {
        SQLRestResponse result = this.client.executeRequest("/_xpack/sql", entity, new SQLRestResponseHandler());
        return ResultUtil.buildSQLResult(result, beanType);
    }

    @Override
    public <T> SQLResult<T> fetchQuery(Class<T> beanType, String entity, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> SQLResult<T> fetchQuery(Class<T> beanType, String entity, Object bean) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> SQLResult<T> fetchQuery(Class<T> beanType, String entity) throws ElasticSearchException {
        SQLRestResponse result = this.client.executeRequest("/_xpack/sql", entity, new SQLRestResponseHandler());
        SQLResult<T> datas = ResultUtil.buildFetchSQLResult(result, beanType, (SQLResult)null);
        datas.setClientInterface(this);
        return datas;
    }

    @Override
    public <T> T sqlObject(Class<T> beanType, String entity, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T sqlObject(Class<T> beanType, String entity, Object bean) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T sqlObject(Class<T> beanType, String entity) throws ElasticSearchException {
        SQLRestResponse result = this.client.executeRequest("/_xpack/sql", entity, new SQLRestResponseHandler());
        return ResultUtil.buildSQLObject(result, beanType);
    }

    @Override
    public String closeSQLCursor(String cursor) throws ElasticSearchException {
        return this.client.executeRequest("/_xpack/sql/close", "{\"cursor\": \"" + cursor + "\"}", new ESStringResponseHandler(), "post");
    }

    @Override
    public <T> SQLResult<T> fetchQueryByCursor(Class<T> beanType, SQLResult<T> oldPage) throws ElasticSearchException {
        if (oldPage.getCursor() == null) {
            return null;
        }
        SQLRestResponse result = this.client.executeRequest("/_xpack/sql", "{\"cursor\": \"" + oldPage.getCursor() + "\"}", new SQLRestResponseHandler());
        SQLResult<T> datas = ResultUtil.buildFetchSQLResult(result, beanType, oldPage);
        datas.setClientInterface(this);
        return datas;
    }

    @Override
    public <T> SQLResult<T> fetchQueryByCursor(Class<T> beanType, String cursor, ColumnMeta[] metas) throws ElasticSearchException {
        if (cursor == null) {
            return null;
        }
        SQLRestResponse result = this.client.executeRequest("/_xpack/sql", "{\"cursor\": \"" + cursor + "\"}", new SQLRestResponseHandler());
        SQLResult<T> datas = ResultUtil.buildFetchSQLResult(result, beanType, metas);
        datas.setClientInterface(this);
        return datas;
    }

    @Override
    public String executeHttp(String path, String action) throws ElasticSearchException {
        return this.client.executeHttp(path, action);
    }

    @Override
    public String executeHttp(String path, String entity, String action) throws ElasticSearchException {
        return this.client.executeHttp(path, entity, action);
    }

    @Override
    public <T> T executeHttp(String path, String entity, String action, Map params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return null;
    }

    @Override
    public String executeHttp(String path, String entity, Map params, String action) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T executeHttp(String path, String entity, String action, Object bean, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return null;
    }

    @Override
    public String executeHttp(String path, String entity, Object bean, String action) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T executeHttp(String path, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.client.executeHttp(path, action, responseHandler);
    }

    @Override
    public <T> T discover(String path, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.client.discover(path, action, responseHandler);
    }

    @Override
    public <T> T executeHttp(String path, String entity, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.client.executeHttp(path, entity, action, responseHandler);
    }

    @Override
    public String getIndexMapping(String index) throws ElasticSearchException {
        return this.getIndexMapping(index, true);
    }

    @Override
    public <T> T getIndexMapping(String index, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.getIndexMapping(index, true, responseHandler);
    }

    @Override
    public String getIndexMapping(String index, boolean pretty) throws ElasticSearchException {
        try {
            if (pretty) {
                return this.client.executeHttp(index + "/_mapping?pretty", "get");
            }
            return this.client.executeHttp(index + "/_mapping", "get");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 4);
        }
    }

    @Override
    public <T> T getIndexMapping(String index, boolean pretty, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        try {
            if (pretty) {
                return this.client.executeRequest(index + "/_mapping?pretty", null, responseHandler, "get");
            }
            return this.client.executeRequest(index + "/_mapping", null, responseHandler, "get");
        }
        catch (ElasticSearchException e) {
            return (T)ResultUtil.hand404HttpRuntimeException(e, Object.class, 4);
        }
    }

    @Override
    public String deleteByPath(String path) throws ElasticSearchException {
        try {
            return this.client.executeHttp(path, "delete");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 2);
        }
    }

    @Override
    public boolean existIndice(String indiceName) throws ElasticSearchException {
        try {
            this.executeHttp(indiceName, "head");
            return true;
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, Boolean.TYPE, 5);
        }
    }

    @Override
    public boolean existIndiceType(String indiceName, String type) throws ElasticSearchException {
        try {
            this.executeHttp(indiceName + "/_mapping/" + type, "head");
            return true;
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, Boolean.TYPE, 6);
        }
    }

    @Override
    public <T> T executeRequest(String path, String templateName, Map params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T executeRequest(String path, String templateName, Object params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return null;
    }

    @Override
    public MapRestResponse search(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public MapRestResponse search(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public MapRestResponse search(String path, String entity) throws ElasticSearchException {
        MapRestResponse searchResult = this.client.executeRequest(path, entity, new ElasticSearchMapResponseHandler());
        return searchResult;
    }

    @Override
    public long count(String index, String entity) throws ElasticSearchException {
        MapRestResponse searchResult = this.client.executeRequest(index + "/_count", entity, new ElasticSearchMapResponseHandler());
        return searchResult.getCount();
    }

    @Override
    public long count(String index, String template, Map params) throws ElasticSearchException {
        throw new ElasticSearchException("Un implements method");
    }

    @Override
    public long count(String index, String template, Object params) throws ElasticSearchException {
        throw new ElasticSearchException("Un implements method");
    }

    @Override
    public long countAll(String index) throws ElasticSearchException {
        String queryAll = "{\"query\": {\"match_all\": {}}}";
        MapRestResponse searchResult = this.client.executeRequest(index + "/_count", queryAll, new ElasticSearchMapResponseHandler());
        return searchResult.getCount();
    }

    @Override
    public <T> ESDatas<T> searchAll(String index, Class<T> type) throws ElasticSearchException {
        return this.searchAll(index, 5000, type);
    }

    @Override
    public <T> ESDatas<T> searchAll(String index, int fetchSize, Class<T> type) throws ElasticSearchException {
        return this.searchAll(index, fetchSize, (ScrollHandler)null, type);
    }

    @Override
    public <T> ESDatas<T> searchAll(String index, int fetchSize, ScrollHandler<T> scrollHandler, Class<T> type) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        String queryAll = builder.append("{ \"size\":").append(fetchSize).append(",\"query\": {\"match_all\": {}}}").toString();
        builder.setLength(0);
        return this.scroll(builder.append(index).append("/_search").toString(), queryAll, "1m", type, scrollHandler);
    }

    @Override
    public <T> ESDatas<T> searchAll(String index, ScrollHandler<T> scrollHandler, Class<T> type) throws ElasticSearchException {
        return this.searchAll(index, 5000, scrollHandler, type);
    }

    @Override
    public <T> ESDatas<T> searchAll(String index, int fetchSize, Class<T> type, int thread) throws ElasticSearchException {
        return this.searchAll(index, fetchSize, null, type, thread);
    }

    @Override
    public <T> ESDatas<T> searchAll(String index, Class<T> type, int thread) throws ElasticSearchException {
        return this.searchAll(index, 5000, type, thread);
    }

    @Override
    public <T> ESDatas<T> searchAll(String index, final int fetchSize, ScrollHandler<T> scrollHandler, Class<T> type, int max) throws ElasticSearchException {
        SliceScroll sliceScroll = new SliceScroll(){

            @Override
            public String buildSliceDsl(int sliceId, int max) {
                StringBuilder builder = new StringBuilder();
                String sliceDsl = builder.append("{\"slice\": {\"id\": ").append(sliceId).append(",\"max\": ").append(max).append("},\"size\":").append(fetchSize).append(",\"query\": {\"match_all\": {}}}").toString();
                return sliceDsl;
            }
        };
        return this._slice(index + "/_search", scrollHandler, type, max, "1m", sliceScroll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> ESDatas<T> _slice(String path, ScrollHandler<T> scrollHandler, final Class<T> type, int max, final String scroll, SliceScroll sliceScroll) throws ElasticSearchException {
        final ArrayList<String> scrollIds = new ArrayList<String>();
        long starttime = System.currentTimeMillis();
        final String _path = path.indexOf(63) < 0 ? path + "?scroll=" + scroll : path + "&scroll=" + scroll;
        ExecutorService executorService = this.client.getSliceScrollQueryExecutorService();
        ArrayList<Future> tasks = new ArrayList<Future>();
        final ParallelSliceScrollResult<T> sliceScrollResult = new ParallelSliceScrollResult<T>();
        if (scrollHandler != null) {
            sliceScrollResult.setScrollHandler(scrollHandler);
        }
        try {
            int j = 0;
            while (j < max) {
                final int i = j++;
                final String sliceDsl = sliceScroll.buildSliceDsl(i, max);
                tasks.add(executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RestClientUtil.this._doSliceScroll(i, _path, sliceDsl, scroll, type, scrollIds, sliceScrollResult);
                        }
                        catch (ElasticSearchException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new ElasticSearchException("slice query task[" + i + "] failed:", e);
                        }
                    }
                }));
            }
        }
        finally {
            this.waitTasksComplete(tasks);
        }
        if (logger.isDebugEnabled()) {
            long endtime = System.currentTimeMillis();
            logger.debug("Slice scroll query\u8017\u65f6\uff1a" + (endtime - starttime) + ",realTotalSize\uff1a" + sliceScrollResult.getRealTotalSize());
        }
        if (scrollIds.size() > 0) {
            this.deleteScrolls(scrollIds);
        }
        sliceScrollResult.complete();
        return sliceScrollResult.getSliceResponse();
    }

    protected void waitTasksComplete(List<Future> tasks) {
        for (Future future : tasks) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                logger.error("", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    @Override
    public <T> ESDatas<T> searchAll(String index, ScrollHandler<T> scrollHandler, Class<T> type, int thread) throws ElasticSearchException {
        return this.searchAll(index, 5000, scrollHandler, type, thread);
    }

    protected <T> void _doSliceScroll(int i, String path, String entity, String scroll, Class<T> type, List<String> scrollIds, SliceScrollResultInf<T> sliceScrollResult) throws Exception {
        try {
            RestResponse result = this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
            ESDatas<T> sliceResponse = ResultUtil.buildESDatas(result, type);
            List<T> sliceDatas = sliceResponse.getDatas();
            String scrollId = sliceResponse.getScrollId();
            if (scrollId != null) {
                scrollIds.add(scrollId);
            }
            if (sliceDatas != null && sliceDatas.size() > 0) {
                ScrollHandler<T> _scrollHandler = sliceScrollResult.getScrollHandler();
                if (_scrollHandler == null) {
                    _scrollHandler = sliceScrollResult.setScrollHandler(sliceResponse);
                } else {
                    _scrollHandler.handle(sliceResponse);
                    sliceScrollResult.setSliceResponse(sliceResponse);
                }
                sliceScrollResult.incrementSize(sliceDatas.size());
                ESDatas<T> _sliceResponse = null;
                List<T> _sliceDatas = null;
                while (true) {
                    String sliceScrollId;
                    if ((sliceScrollId = (_sliceResponse = this.searchScroll(scroll, scrollId, type)).getScrollId()) != null) {
                        scrollIds.add(sliceScrollId);
                    }
                    if ((_sliceDatas = _sliceResponse.getDatas()) != null && _sliceDatas.size() != 0) {
                        _scrollHandler.handle(_sliceResponse);
                        sliceScrollResult.incrementSize(_sliceDatas.size());
                        continue;
                    }
                    break;
                }
            }
        }
        catch (ElasticSearchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ElasticSearchException("slice query task[" + i + "] failed:", e);
        }
    }

    @Override
    public TermRestResponse termSuggest(String path, String entity) throws ElasticSearchException {
        TermRestResponse searchResult = this.client.executeRequest(path, entity, new ElasticSearchTermResponseHandler());
        return searchResult;
    }

    @Override
    public PhraseRestResponse phraseSuggest(String path, String entity) throws ElasticSearchException {
        PhraseRestResponse searchResult = this.client.executeRequest(path, entity, new ElasticSearchPhraseResponseHandler());
        return searchResult;
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String entity, Class<?> type) throws ElasticSearchException {
        RestResponse searchResult = this.client.executeRequest(path, entity, new CompleteElasticSearchResponseHandler(type));
        return (CompleteRestResponse)searchResult;
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String entity) throws ElasticSearchException {
        RestResponse searchResult = this.client.executeRequest(path, entity, new CompleteElasticSearchResponseHandler(Map.class));
        return (CompleteRestResponse)searchResult;
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public TermRestResponse termSuggest(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public PhraseRestResponse phraseSuggest(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public TermRestResponse termSuggest(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public PhraseRestResponse phraseSuggest(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Object params, Class<?> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Map params, Class<?> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String templateName, Map params, Class<?> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String templateName, Object params, Class<?> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String entity, Class<?> type) throws ElasticSearchException {
        RestResponse searchResult = this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
        return searchResult;
    }

    @Override
    public <T> ESDatas<T> searchScroll(String scroll, String scrollId, Class<T> type) throws ElasticSearchException {
        StringBuilder entity = new StringBuilder();
        entity.append("{\"scroll\" : \"").append(scroll).append("\",\"scroll_id\" : \"").append(scrollId).append("\"}");
        RestResponse result = this.client.executeRequest("_search/scroll", entity.toString(), new ElasticSearchResponseHandler(type));
        return ResultUtil.buildESDatas(result, type);
    }

    @Override
    public String searchScroll(String scroll, String scrollId) throws ElasticSearchException {
        StringBuilder entity = new StringBuilder();
        entity.append("{\"scroll\" : \"").append(scroll).append("\",\"scroll_id\" : \"").append(scrollId).append("\"}");
        String result = this.client.executeHttp("_search/scroll", entity.toString(), "get");
        return result;
    }

    @Override
    public String deleteScrolls(String ... scrollIds) throws ElasticSearchException {
        if (scrollIds == null || scrollIds.length == 0) {
            return null;
        }
        StringBuilder entity = new StringBuilder();
        entity.append("{\"scroll_id\" : [");
        for (int i = 0; i < scrollIds.length; ++i) {
            String scrollId = scrollIds[i];
            if (i > 0) {
                entity.append(",");
            }
            entity.append("\"").append(scrollId).append("\"");
        }
        entity.append("]}");
        String result = this.client.executeHttp("_search/scroll", entity.toString(), "delete");
        return result;
    }

    @Override
    public String deleteScrolls(List<String> scrollIds) throws ElasticSearchException {
        if (scrollIds == null || scrollIds.size() == 0) {
            return null;
        }
        StringBuilder entity = new StringBuilder();
        entity.append("{\"scroll_id\" : [");
        for (int i = 0; i < scrollIds.size(); ++i) {
            String scrollId = scrollIds.get(i);
            if (i > 0) {
                entity.append(",");
            }
            entity.append("\"").append(scrollId).append("\"");
        }
        entity.append("]}");
        String result = this.client.executeHttp("_search/scroll", entity.toString(), "delete");
        return result;
    }

    @Override
    public String deleteAllScrolls() throws ElasticSearchException {
        String result = this.client.executeHttp("_search/scroll/_all", "delete");
        return result;
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String entity, Class<T> type) throws ElasticSearchException {
        RestResponse result = this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
        return ResultUtil.buildESDatas(result, type);
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Map params, Class<T> type) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Map params, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String entity, String scroll, Class<T> type) throws ElasticSearchException {
        return this.scroll(path, entity, scroll, type, (ScrollHandler)null);
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String entity, String scroll, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        try {
            path = path.indexOf(63) < 0 ? path + "?scroll=" + scroll : path + "&scroll=" + scroll;
            RestResponse result = this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
            ESDatas response = ResultUtil.buildESDatas(result, type);
            boolean useDefaultScrollHandler = false;
            if (scrollHandler == null) {
                scrollHandler = new DefualtScrollHandler<T>(response);
                useDefaultScrollHandler = true;
            } else {
                scrollHandler.handle(response);
            }
            List<T> datas = response.getDatas();
            ArrayList<String> scrollIds = new ArrayList<String>();
            String scrollId = response.getScrollId();
            if (scrollId != null) {
                scrollIds.add(scrollId);
            }
            if (datas != null && datas.size() > 0) {
                ESDatas<T> _response = null;
                List<T> _datas = null;
                while (true) {
                    if ((scrollId = (_response = this.searchScroll(scroll, scrollId, type)).getScrollId()) != null) {
                        scrollIds.add(scrollId);
                    }
                    if ((_datas = _response.getDatas()) == null || _datas.size() == 0) break;
                    scrollHandler.handle(_response);
                }
            }
            if (scrollIds.size() > 0) {
                this.deleteScrolls(scrollIds);
            }
            if (!useDefaultScrollHandler) {
                response.setDatas(null);
            }
            return response;
        }
        catch (ElasticSearchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
    }

    @Override
    public <T> ESDatas<T> scrollSlice(String path, String dslTemplate, Map params, String scroll, Class<T> type, boolean parallel) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ESDatas<T> scrollSlice(String path, String dslTemplate, Map params, String scroll, Class<T> type, ScrollHandler<T> scrollHandler, boolean parallel) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Object params, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Object params, Class<T> type) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    public <T> ESDatas<T> scrollSlice(String path, String dslTemplate, Object params, int max, String scroll, Class<T> type, ScrollHandler<T> scrollHandler, boolean parallel) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    public <T> ESDatas<T> scrollSlice(String path, String dslTemplate, Object params, int max, String scroll, Class<T> type, boolean parallel) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T searchObject(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T searchObject(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T searchObject(String path, String entity, Class<T> type) throws ElasticSearchException {
        RestResponse result = this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
        return ResultUtil.buildObject(result, type);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Map params, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Object params, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Map params, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Object params, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        RestResponse result = this.client.executeRequest(path, entity, new ElasticSearchResponseHandler());
        return ResultUtil.buildESAggDatas(result, type, aggs, stats, null);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        RestResponse result = this.client.executeRequest(path, entity, new ElasticSearchResponseHandler());
        return ResultUtil.buildESAggDatas(result, type, aggs, stats, aggBucketHandle);
    }

    @Override
    public String createTempate(String template, String entity) throws ElasticSearchException {
        return this.client.executeHttp("_template/" + template, entity, "put");
    }

    @Override
    public String createTempate(String template, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String createTempate(String template, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String templateName, Map params, ESTypeReferences type) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String templateName, Object params, ESTypeReferences type) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String entity, ESTypeReferences type) throws ElasticSearchException {
        return this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public Map<String, Object> searchMap(String path, String entity) throws ElasticSearchException {
        return this.client.executeRequest(path, entity, new ESMapResponseHandler());
    }

    @Override
    public String dropIndice(String index) throws ElasticSearchException {
        try {
            return this.client.executeHttp(index + "?pretty", "delete");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 7);
        }
    }

    @Override
    public String updateIndiceMapping(String action, String indexMapping) throws ElasticSearchException {
        try {
            return this.client.executeHttp(action, indexMapping, "post");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 8);
        }
    }

    @Override
    public String createIndiceMapping(String indexName, String indexMapping) throws ElasticSearchException {
        return this.client.executeHttp(indexName, indexMapping, "put");
    }

    @Override
    public String updateIndiceMapping(String action, String templateName, Object parameter) throws ElasticSearchException {
        return null;
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName, Object parameter) throws ElasticSearchException {
        return null;
    }

    @Override
    public String updateIndiceMapping(String action, String templateName, Map parameter) throws ElasticSearchException {
        return null;
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName, Map parameter) throws ElasticSearchException {
        return null;
    }

    @Override
    public String getIndice(String index) throws ElasticSearchException {
        return this.getIndexMapping(index, true);
    }

    @Override
    public List<ESIndice> getIndexes() throws ElasticSearchException {
        String data = this.client.executeHttp("_cat/indices?v", "get");
        logger.debug(data);
        if (SimpleStringUtil.isNotEmpty((String)data)) {
            try {
                List<ESIndice> indices = this.extractIndice(data);
                return indices;
            }
            catch (IOException e) {
                throw new ElasticSearchException(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ESIndice> extractIndice(String data) throws IOException {
        StringReader reader = null;
        BufferedReader br = null;
        try {
            String line;
            reader = new StringReader(data);
            br = new BufferedReader(reader);
            ArrayList<ESIndice> indices = new ArrayList<ESIndice>();
            int i = 0;
            SimpleDateFormat format = new SimpleDateFormat(this.client.getDateFormat());
            while ((line = br.readLine()) != null) {
                if (i == 0) {
                    ++i;
                    continue;
                }
                ESIndice esIndice = BuildTool.buildESIndice(line, format);
                indices.add(esIndice);
            }
            ArrayList<ESIndice> arrayList = indices;
            return arrayList;
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String refreshIndexInterval(String indexName, int interval) throws ElasticSearchException {
        return this.client.executeHttp(indexName + "/_settings", "{  \"index\" : {  \"refresh_interval\" : \"" + interval + "s\"   } }", "put");
    }

    @Override
    public String refreshIndexInterval(String indexName, String indexType, int interval) throws ElasticSearchException {
        return this.client.executeHttp(indexName + "/" + indexType + "/_settings", "{  \"index\" : {  \"refresh_interval\" : \"" + interval + "s\"    } }", "put");
    }

    @Override
    public String refreshIndexInterval(int interval, boolean preserveExisting) throws ElasticSearchException {
        if (preserveExisting) {
            return this.client.executeHttp("_all/_settings?preserve_existing=true", "{  \"index\" : {  \"refresh_interval\" : \"" + interval + "s\"    } }", "put");
        }
        return this.client.executeHttp("_all/_settings?preserve_existing=false", "{  \"index\" : {  \"refresh_interval\" : \"" + interval + "s\"    } }", "put");
    }

    @Override
    public String refreshIndexInterval(int interval) throws ElasticSearchException {
        return this.refreshIndexInterval(interval, false);
    }

    @Override
    public String cleanAllXPackIndices() throws ElasticSearchException {
        StringBuilder ret = new StringBuilder();
        for (String monitor : this.monitorIndices) {
            try {
                ret.append(this.client.executeHttp(URLEncoder.encode(monitor, "UTF-8") + "?pretty", "delete")).append("\n");
            }
            catch (Exception e) {
                ret.append(e.getMessage()).append("\n");
            }
        }
        return ret.toString();
    }

    @Override
    public String updateByPath(String path, String entity) throws ElasticSearchException {
        try {
            return this.client.executeHttp(path, entity, "post");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 1);
        }
    }

    @Override
    public String updateByPath(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String updateByPath(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String updateByQuery(String path) throws ElasticSearchException {
        return this.client.executeHttp(path, "post");
    }

    @Override
    public String updateByQuery(String path, String entity) throws ElasticSearchException {
        return this.client.executeHttp(path, entity, "post");
    }

    @Override
    public String updateByQuery(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String updateByQuery(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> List<T> mgetDocuments(String index, String indexType, Class<T> type, Object ... ids) throws ElasticSearchException {
        if (ids == null || ids.length == 0) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        if (indexType == null || indexType.equals("")) {
            path.append(index).append("/_mget");
        } else {
            path.append(index).append("/").append(indexType).append("/_mget");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" {\"ids\":");
        BBossStringWriter writer = new BBossStringWriter(builder);
        SerialUtil.object2json(ids, (Writer)writer);
        builder.append("}");
        MGetDocs searchResult = this.client.executeRequest(path.toString(), builder.toString(), new MGetDocumentsSourceResponseHandler((Class)type), "post");
        return ResultUtil.buildObjects(searchResult, type);
    }

    @Override
    public String mgetDocuments(String index, String indexType, Object ... ids) throws ElasticSearchException {
        if (ids == null || ids.length == 0) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        if (indexType == null || indexType.equals("")) {
            path.append(index).append("/_mget");
        } else {
            path.append(index).append("/").append(indexType).append("/_mget");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" {\"ids\":");
        BBossStringWriter writer = new BBossStringWriter(builder);
        SerialUtil.object2json(ids, (Writer)writer);
        builder.append("}");
        String searchResult = this.client.executeHttp(path.toString(), builder.toString(), "post");
        return searchResult;
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Object params) throws ElasticSearchException {
        return this.updateDocument(index, indexType, id, params, (String)null);
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Map params) throws ElasticSearchException {
        return this.updateDocument(index, indexType, id, params, (String)null);
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Map params, String refreshOption) throws ElasticSearchException {
        return this.updateDocument(index, indexType, id, params, refreshOption, (Boolean)null, (Boolean)null);
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Object params, String refreshOption) throws ElasticSearchException {
        return this.updateDocument(index, indexType, id, params, refreshOption, (Boolean)null, (Boolean)null);
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Object params, Boolean detect_noop, Boolean doc_as_upsert) throws ElasticSearchException {
        return this.updateDocument(index, indexType, id, params, (String)null, detect_noop, doc_as_upsert);
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Map params, Boolean detect_noop, Boolean doc_as_upsert) throws ElasticSearchException {
        return this.updateDocument(index, indexType, id, params, (String)null, detect_noop, doc_as_upsert);
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Map params, String refreshOption, Boolean detect_noop, Boolean doc_as_upsert) throws ElasticSearchException {
        StringBuilder path = new StringBuilder();
        if (indexType == null || indexType.equals("")) {
            path.append(index).append("/").append(id).append("/_update");
        } else {
            path.append(index).append("/").append(indexType).append("/").append(id).append("/_update");
        }
        if (refreshOption != null) {
            path.append("?").append(refreshOption);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" {\"doc\":");
        BBossStringWriter writer = new BBossStringWriter(builder);
        SerialUtil.object2json(params, (Writer)writer);
        if (detect_noop != null) {
            builder.append(",\"detect_noop\":").append(detect_noop);
        }
        if (doc_as_upsert != null) {
            builder.append(",\"doc_as_upsert\":").append(doc_as_upsert);
        }
        builder.append("}");
        try {
            String searchResult = this.client.executeHttp(path.toString(), builder.toString(), "post");
            return searchResult;
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 1);
        }
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Object params, String refreshOption, Boolean detect_noop, Boolean doc_as_upsert) throws ElasticSearchException {
        StringBuilder path = new StringBuilder();
        if (indexType == null || indexType.equals("")) {
            path.append(index).append("/").append(id).append("/_update");
        } else {
            path.append(index).append("/").append(indexType).append("/").append(id).append("/_update");
        }
        if (refreshOption != null) {
            path.append("?").append(refreshOption);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" {\"doc\":");
        BBossStringWriter writer = new BBossStringWriter(builder);
        SerialUtil.object2json(params, (Writer)writer);
        if (detect_noop != null) {
            builder.append(",\"detect_noop\":").append(detect_noop);
        }
        if (doc_as_upsert != null) {
            builder.append(",\"doc_as_upsert\":").append(doc_as_upsert);
        }
        builder.append("}");
        try {
            String searchResult = this.client.executeHttp(path.toString(), builder.toString(), "post");
            return searchResult;
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 1);
        }
    }

    @Override
    public String reindex(String sourceIndice, String destIndice) {
        String reindex = "{\"source\": {\"index\": \"" + sourceIndice + "\"},\"dest\": {\"index\": \"" + destIndice + "\"}}";
        return this.client.executeHttp("_reindex", reindex, "post");
    }

    @Override
    public String reindex(String sourceIndice, String destIndice, String versionType) {
        String reindex = "{\"source\": {\"index\": \"" + sourceIndice + "\"},\"dest\": {\"index\": \"" + destIndice + "\",\"version_type\": \"" + versionType + "\"}}";
        return this.client.executeHttp("_reindex", reindex, "post");
    }

    @Override
    public String reindex(String sourceIndice, String destIndice, String opType, String conflicts) {
        if (conflicts == null || conflicts.equals("")) {
            String reindex = "{\"source\": {\"index\": \"" + sourceIndice + "\"},\"dest\": {\"index\": \"" + destIndice + "\",\"op_type\": \"" + opType + "\"}}";
            return this.client.executeHttp("_reindex", reindex, "post");
        }
        String reindex = "{\"conflicts\": \"" + conflicts + "\",\"source\": {\"index\": \"" + sourceIndice + "\"},\"dest\": {\"index\": \"" + destIndice + "\",\"op_type\": \"" + opType + "\"}}";
        return this.client.executeHttp("_reindex", reindex, "post");
    }

    @Override
    public String addAlias(String indice, String alias) {
        String aliasJson = "{\"actions\": [{\"add\": {\"index\":\"" + indice + "\",\"alias\": \"" + alias + "\"}}]}";
        return this.client.executeHttp("_aliases", aliasJson, "post");
    }

    @Override
    public String removeAlias(String indice, String alias) {
        String removeAlias = "{\"actions\": [{\"remove\": {\"index\":\"" + indice + "\",\"alias\": \"" + alias + "\"}}]}";
        return this.client.executeHttp("_aliases", removeAlias, "post");
    }
}

