/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.assemble;

import com.frameworkset.orm.annotation.TransactionType;
import com.frameworkset.orm.transaction.TransactionException;
import com.frameworkset.util.RegexUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.TXUtil;
import org.frameworkset.spi.assemble.BeanAccembleHelper;
import org.frameworkset.spi.assemble.Param;
import org.frameworkset.spi.assemble.Pro;
import org.frameworkset.spi.assemble.RollbackException;
import org.frameworkset.spi.async.annotation.Async;
import org.frameworkset.spi.async.annotation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizedMethod
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(SynchronizedMethod.class);
    private String methodName;
    private String pattern;
    private List<Pro> params;
    private Map<String, Pro> paramIndexs;
    private List<RollbackException> rollbackExceptions;
    private Map<String, Boolean> rollbackExceptionIndexs;
    private long asynctimeout;
    private Result asyncResult;
    private TransactionType txtype = TransactionType.REQUIRED_TRANSACTION;
    private String asyncCallback;
    private String uuid;

    public SynchronizedMethod() {
        this.params = new ArrayList<Pro>();
        this.paramIndexs = new HashMap<String, Pro>();
        this.rollbackExceptions = new ArrayList<RollbackException>();
        this.rollbackExceptionIndexs = new HashMap<String, Boolean>();
    }

    public SynchronizedMethod(Method method, Async async) {
        this.uuid = SynchronizedMethod.buildMethodUUID(method);
        this.asynctimeout = async.timeout();
        this.asyncCallback = async.callback().equals("NULLCALLBACK") ? null : async.callback();
        this.asyncResult = async.result();
    }

    public long getAsyncTimeout() {
        return this.asynctimeout;
    }

    public String getAsyncCallback() {
        return this.asyncCallback;
    }

    public Result getAsyncResultMode() {
        return this.asyncResult;
    }

    public SynchronizedMethod(Method method, TransactionType txtype, String[] rollbacksexceptions) {
        this.rollbackExceptions = new ArrayList<RollbackException>();
        this.rollbackExceptionIndexs = new HashMap<String, Boolean>();
        this.uuid = SynchronizedMethod.buildMethodUUID(method);
        this.setTxtype(txtype);
        if (rollbacksexceptions != null && rollbacksexceptions.length > 0) {
            this.buildRollbackExceptios(rollbacksexceptions);
        }
    }

    private void buildRollbackExceptios(String[] rollbacksexceptions) {
        if (rollbacksexceptions == null || rollbacksexceptions.length == 0) {
            return;
        }
        for (String e : rollbacksexceptions) {
            if (e.equals("")) continue;
            int i = e.indexOf(64);
            if (i > 0) {
                String exceptionName = e.substring(0, i);
                String exceptionType = e.substring(i + 1);
                RollbackException RollbackException2 = new RollbackException();
                RollbackException2.setExceptionName(exceptionName);
                RollbackException2.setExceptionType(exceptionType);
                this.rollbackExceptions.add(RollbackException2);
                continue;
            }
            RollbackException RollbackException3 = new RollbackException();
            RollbackException3.setExceptionName(e);
            RollbackException3.setExceptionType("INSTANCEOF");
            this.rollbackExceptions.add(RollbackException3);
        }
    }

    public static void main(String[] args) {
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void addParam(Pro param) {
        this.params.add(param);
        this.paramIndexs.put(param.getClazz(), param);
    }

    public List getParams() {
        return this.params;
    }

    public List getRollbackExceptions() {
        return this.rollbackExceptions;
    }

    public void addRollbackException(RollbackException rollbackException) {
        this.rollbackExceptions.add(rollbackException);
    }

    public Param getParam(String paramtype) {
        return (Param)this.paramIndexs.get(paramtype);
    }

    public String getUUID() {
        try {
            if (this.uuid != null) {
                return this.uuid;
            }
            if (this.isPattern()) {
                this.uuid = this.pattern;
                return this.uuid;
            }
            StringBuilder uuid_ = new StringBuilder();
            uuid_.append(this.methodName);
            if (this.params != null) {
                for (int i = 0; i < this.params.size(); ++i) {
                    Pro param = this.params.get(i);
                    uuid_.append("_").append(param.getClazz());
                }
            }
            this.uuid = uuid_.toString();
            return this.uuid;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static String buildMethodUUID(Method method, Object[] args) {
        return SynchronizedMethod.buildMethodUUID(method.getName(), method.getParameterTypes());
    }

    public static String buildMethodUUID(String method, Class[] paramTypes) {
        try {
            StringBuilder uuid = new StringBuilder();
            uuid.append(method);
            if (paramTypes == null || paramTypes.length == 0) {
                return uuid.toString();
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                uuid.append("_").append(paramTypes[i].getName());
            }
            return uuid.toString();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static MethodInfo refactorMehtodfromUUID(String methodUUID) throws ClassNotFoundException {
        int index = methodUUID.lastIndexOf("_");
        MethodInfo methodInfo = new MethodInfo();
        if (index <= 0) {
            methodInfo.setMethodName(methodUUID);
            return methodInfo;
        }
        String[] infos = methodUUID.split("_");
        methodInfo.setMethodName(infos[0]);
        Class[] classes = new Class[infos.length - 1];
        for (int i = 1; i < infos.length; ++i) {
            classes[i - 1] = BeanAccembleHelper.getClass(infos[i]);
        }
        methodInfo.setParamTypes(classes);
        return methodInfo;
    }

    public static String buildMethodUUID(Method method) {
        return SynchronizedMethod.buildMethodUUID(method, null);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean isPattern() {
        return this.pattern != null && !this.pattern.equals("");
    }

    public boolean match(Method method) {
        return this.match(method, null);
    }

    public boolean match(Method method, String methodUUID) {
        try {
            boolean match = false;
            if (this.isPattern()) {
                if (this.pattern.equals("*")) {
                    return true;
                }
                String methodname = method.getName();
                match = RegexUtil.isMatch((String)methodname, (String)this.getPattern());
                return match;
            }
            if (methodUUID == null) {
                methodUUID = SynchronizedMethod.buildMethodUUID(method);
            }
            if (this.getUUID().equals(methodUUID)) {
                match = true;
            }
            return match;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public TransactionType getTxtype() {
        return this.txtype;
    }

    public void setTxtype(String txtype) {
        if (txtype == null) {
            return;
        }
        if (txtype.equals("NEW_TRANSACTION")) {
            this.txtype = TransactionType.NEW_TRANSACTION;
        } else if (txtype.equals("REQUIRED_TRANSACTION")) {
            this.txtype = TransactionType.REQUIRED_TRANSACTION;
        } else if (txtype.equals("MAYBE_TRANSACTION")) {
            this.txtype = TransactionType.MAYBE_TRANSACTION;
        } else if (txtype.equals("NO_TRANSACTION")) {
            this.txtype = TransactionType.NO_TRANSACTION;
        } else if (txtype.equals("RW_TRANSACTION")) {
            this.txtype = TransactionType.RW_TRANSACTION;
        }
    }

    public void setTxtype(TransactionType txtype) {
        if (txtype == null) {
            return;
        }
        this.txtype = txtype;
    }

    public boolean isRollbackException(Throwable throwable) {
        if (this.rollbackExceptions == null || this.rollbackExceptions.size() == 0) {
            return true;
        }
        String key = throwable.getClass().getName();
        Boolean t = this.rollbackExceptionIndexs.get(key);
        if (t != null) {
            return t;
        }
        try {
            if (throwable instanceof TransactionException || TXUtil.isRollbackException(throwable.getClass()) || throwable instanceof SQLException || throwable instanceof RuntimeException || throwable instanceof Error) {
                t = new Boolean(true);
                this.rollbackExceptionIndexs.put(key, t);
                return true;
            }
            if (this.rollbackExceptions != null && this.rollbackExceptions.size() > 0) {
                for (int i = 0; i < this.rollbackExceptions.size(); ++i) {
                    RollbackException re = this.rollbackExceptions.get(i);
                    if (re.getExceptionType() == 0) {
                        if (throwable.getClass() != re.getExceptionClass()) continue;
                        t = new Boolean(true);
                        this.rollbackExceptionIndexs.put(key, t);
                        return true;
                    }
                    if (re.getExceptionType() != 1 || re.getExceptionClass() == null || !re.getExceptionClass().isAssignableFrom(throwable.getClass())) continue;
                    t = new Boolean(true);
                    this.rollbackExceptionIndexs.put(key, t);
                    return true;
                }
                t = new Boolean(false);
                this.rollbackExceptionIndexs.put(key, t);
                return false;
            }
            t = new Boolean(true);
            this.rollbackExceptionIndexs.put(key, t);
            return true;
        }
        catch (Exception e) {
            t = new Boolean(true);
            this.rollbackExceptionIndexs.put(key, t);
            log.error(e.getMessage(), (Throwable)e);
            return true;
        }
    }

    public static class MethodInfo
    implements Serializable {
        private String methodName;
        private Class[] paramTypes;

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public Class[] getParamTypes() {
            return this.paramTypes;
        }

        public void setParamTypes(Class[] paramTypes) {
            this.paramTypes = paramTypes;
        }
    }
}

