/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.assemble;

import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.assemble.GetProperties;
import org.frameworkset.spi.assemble.LinkConfigFile;
import org.frameworkset.spi.assemble.Pro;
import org.frameworkset.spi.assemble.ProviderParser;
import org.frameworkset.spi.assemble.ServiceProviderManager;
import org.frameworkset.spi.assemble.plugin.PropertiesFilePlugin;
import org.frameworkset.spi.support.EnvUtil;
import org.frameworkset.util.io.ClassPathResource;
import org.frameworkset.util.tokenizer.TextGrammarParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesContainer
implements GetProperties {
    protected List<String> configPropertiesFiles;
    protected Properties allProperties;
    protected Properties sonAndParentProperties;
    private static Logger log = LoggerFactory.getLogger(PropertiesContainer.class);

    public void addConfigPropertiesFile(String configPropertiesFile, LinkConfigFile linkfile) {
        String[] configPropertiesFiles;
        if (this.configPropertiesFiles == null) {
            this.configPropertiesFiles = new ArrayList<String>();
        }
        if (this.allProperties == null) {
            this.allProperties = new Properties();
        }
        for (String file_ : configPropertiesFiles = configPropertiesFile.split(",")) {
            this.configPropertiesFiles.add(file_);
            this.evalfile(file_, linkfile);
        }
        Map evaledProperties = EnvUtil.evalEnvVariable(this.allProperties);
        if (evaledProperties != null) {
            this.allProperties.putAll((Map<?, ?>)evaledProperties);
        }
        if (linkfile != null) {
            this.loopback(linkfile);
        }
    }

    public void addAll(Map properties) {
        if (this.configPropertiesFiles == null) {
            this.configPropertiesFiles = new ArrayList<String>();
        }
        if (this.allProperties == null) {
            this.allProperties = new Properties();
        }
        if (properties != null && properties.size() > 0) {
            this.allProperties.putAll((Map<?, ?>)properties);
        }
    }

    @Override
    public String getExternalProperty(String property) {
        return this.getPropertyFromSelf2ndSons(property);
    }

    @Override
    public String getExternalProperty(String property, String defaultValue) {
        String value = this.getPropertyFromSelf2ndSons(property);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public Object getExternalObjectProperty(String property) {
        return this.getPropertyFromSelf2ndSons(property);
    }

    @Override
    public Object getExternalObjectProperty(String property, Object defaultValue) {
        String value = this.getPropertyFromSelf2ndSons(property);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigPropertiesFromPlugin(String configPropertiesPlugin, LinkConfigFile linkfile, BaseApplicationContext applicationContext) {
        if (this.configPropertiesFiles == null) {
            this.configPropertiesFiles = new ArrayList<String>();
        }
        if (this.allProperties == null) {
            this.allProperties = new Properties();
        }
        try {
            Class<?> clazz = Class.forName(configPropertiesPlugin.trim());
            Class<PropertiesFilePlugin> clazz2 = PropertiesFilePlugin.class;
            synchronized (PropertiesFilePlugin.class) {
                PropertiesFilePlugin propertiesFilePlugin = (PropertiesFilePlugin)clazz.newInstance();
                try {
                    if (propertiesFilePlugin.getInitType() != 1) {
                        String configPropertiesFile = propertiesFilePlugin.getFiles(applicationContext);
                        if (SimpleStringUtil.isNotEmpty((String)configPropertiesFile)) {
                            this.loadPropertiesFromFiles(configPropertiesFile, linkfile);
                        }
                    } else {
                        Map configProperties = propertiesFilePlugin.getConfigProperties(applicationContext);
                        if (configProperties != null && configProperties.size() > 0) {
                            this.allProperties.putAll((Map<?, ?>)configProperties);
                        }
                    }
                    Map evaledProperties = EnvUtil.evalEnvVariable(this.allProperties);
                    if (evaledProperties != null) {
                        this.allProperties.putAll((Map<?, ?>)evaledProperties);
                    }
                }
                finally {
                    propertiesFilePlugin.restore();
                }
                // ** MonitorExit[var5_6] (shouldn't be in output)
                if (linkfile != null) {
                    this.loopback(linkfile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadPropertiesFromFiles(String configPropertiesFile, LinkConfigFile linkfile) {
        String[] configPropertiesFiles;
        for (String file_ : configPropertiesFiles = configPropertiesFile.split(",")) {
            this.configPropertiesFiles.add(file_);
            this.evalfile(file_, linkfile);
        }
    }

    public String evalValue(String value, ProviderParser providerParser) {
        BaseApplicationContext context;
        if (SimpleStringUtil.isEmpty((String)value)) {
            return value;
        }
        String varpre = null;
        String varend = null;
        boolean findVariableFromSelf = false;
        if (providerParser != null && (context = providerParser.getApplicationContext()) != null) {
            varpre = context.getServiceProviderManager().getVarpre();
            varend = context.getServiceProviderManager().getVarend();
            findVariableFromSelf = context.getServiceProviderManager().findVariableFromSelf();
        }
        if (varpre == null) {
            varpre = "${";
        }
        if (varend == null) {
            varend = "}";
        }
        List tokens = TextGrammarParser.parser((String)value, (String)varpre, (char)varend.charAt(0));
        StringBuilder re = new StringBuilder();
        for (int i = 0; tokens != null && i < tokens.size(); ++i) {
            Pro p;
            TextGrammarParser.GrammarToken token = (TextGrammarParser.GrammarToken)tokens.get(i);
            if (token.texttoken()) {
                re.append(token.getText());
                continue;
            }
            String varvalue = this.getProperty(token.getText());
            if (varvalue == null && (p = providerParser._getRealProperty(token.getText())) != null) {
                varvalue = (String)providerParser.getRealPropertyValue(p);
            }
            if (varvalue != null) {
                re.append(varvalue);
                continue;
            }
            if (token.getDefaultValue() != null) {
                re.append(token.getDefaultValue());
                continue;
            }
            re.append(varpre).append(token.getText()).append(varend);
        }
        return re.toString();
    }

    public String escapeValue(String value, ProviderParser providerParser) {
        TextGrammarParser.GrammarToken token;
        int i;
        StringBuilder re;
        List tokens;
        boolean escapeRN;
        BaseApplicationContext context;
        if (SimpleStringUtil.isEmpty((String)value)) {
            return value;
        }
        String escapePre = null;
        String escapeEnd = null;
        String escapeRNPre = null;
        String escapeRNEnd = null;
        ServiceProviderManager serviceProviderManager = null;
        if (providerParser != null && (context = providerParser.getApplicationContext()) != null) {
            serviceProviderManager = context.getServiceProviderManager();
            escapePre = serviceProviderManager.getEscapePre();
            escapeEnd = serviceProviderManager.getEscapeEnd();
            escapeRNPre = serviceProviderManager.getEscapeRNPre();
            escapeRNEnd = serviceProviderManager.getEscapeRNEnd();
        }
        boolean escape = !SimpleStringUtil.isEmpty(escapeEnd) && !SimpleStringUtil.isEmpty(escapePre);
        boolean bl = escapeRN = !SimpleStringUtil.isEmpty(escapeRNPre) && !SimpleStringUtil.isEmpty(escapeRNEnd);
        if (escapeRN) {
            tokens = TextGrammarParser.parser((String)value, escapeRNPre, escapeRNEnd);
            re = new StringBuilder();
            for (i = 0; tokens != null && i < tokens.size(); ++i) {
                token = (TextGrammarParser.GrammarToken)tokens.get(i);
                if (token.texttoken()) {
                    re.append(token.getText());
                    continue;
                }
                re.append("\"");
                serviceProviderManager.escapeRN(token.getText(), re);
                re.append("\"");
            }
            value = re.toString();
        }
        if (escape) {
            tokens = TextGrammarParser.parser((String)value, (String)escapePre, (String)escapeEnd);
            re = new StringBuilder();
            for (i = 0; tokens != null && i < tokens.size(); ++i) {
                token = (TextGrammarParser.GrammarToken)tokens.get(i);
                if (token.texttoken()) {
                    re.append(token.getText());
                    continue;
                }
                re.append("\"");
                serviceProviderManager.escapeValue(token.getText(), re);
                re.append("\"");
            }
            value = re.toString();
        }
        return value;
    }

    public void addConfigPropertiesFile(String configPropertiesFile) {
        this.addConfigPropertiesFile(configPropertiesFile, null);
    }

    private void loopback(LinkConfigFile linkfile) {
        linkfile.loopback(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalfile(String configPropertiesFile, LinkConfigFile linkfile) {
        Properties properties = new Properties();
        InputStream input = null;
        Reader read = null;
        try {
            block36: {
                if (!configPropertiesFile.startsWith("file:")) {
                    ClassPathResource resource = new ClassPathResource(configPropertiesFile);
                    try {
                        input = resource.getInputStream();
                        if (log.isInfoEnabled()) {
                            log.info("load config Properties File :" + resource.getURL());
                        }
                        break block36;
                    }
                    catch (Exception e) {
                        if (linkfile == null) {
                            if (log.isInfoEnabled()) {
                                log.info("load config Properties File :" + configPropertiesFile + " does not exist,Ignore load.");
                            }
                        } else if (log.isInfoEnabled()) {
                            StringBuilder builder = new StringBuilder();
                            builder.append("load config Properties File :").append(configPropertiesFile).append(" in ");
                            linkfile.toString(builder);
                            builder.append(" does not exist,Ignore load.");
                            log.info(builder.toString());
                        }
                        break block36;
                    }
                }
                String _configPropertiesFile = configPropertiesFile.substring("file:".length());
                File configFile = new File(_configPropertiesFile);
                if (configFile.exists()) {
                    input = new FileInputStream(configFile);
                    if (log.isInfoEnabled()) {
                        log.info("load config Properties File :" + _configPropertiesFile);
                    }
                } else if (linkfile == null) {
                    if (log.isInfoEnabled()) {
                        log.info("load config Properties File :" + configPropertiesFile + " does not exist,Ignore load.");
                    } else if (log.isInfoEnabled()) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("load config Properties File :").append(configPropertiesFile).append(" in ");
                        linkfile.toString(builder);
                        builder.append(" does not exist,Ignore load.");
                        log.info(builder.toString());
                    }
                }
            }
            if (input != null) {
                read = new InputStreamReader(input, "UTF-8");
                properties.load(read);
            }
            if (!properties.isEmpty()) {
                this.allProperties.putAll((Map<?, ?>)properties);
            }
        }
        catch (Exception e) {
            log.error("load config Properties File failed:", (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (read != null) {
                try {
                    read.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void mergeParentConfigProperties(PropertiesContainer parent) {
        if (parent == this) {
            return;
        }
        if (this.allProperties == null) {
            this.allProperties = new Properties();
        }
        this.allProperties.putAll(parent.getAllProperties());
    }

    public void mergeSonConfigProperties(PropertiesContainer son) {
        if (this.sonAndParentProperties == null) {
            this.sonAndParentProperties = new Properties();
        }
        if (son.getAllProperties() != null) {
            this.sonAndParentProperties.putAll(son.getAllProperties());
        }
    }

    public Map<Object, Object> getAllProperties() {
        return this.allProperties;
    }

    public String getProperty(String property) {
        if (this.allProperties == null) {
            return null;
        }
        return this.allProperties.getProperty(property);
    }

    public String getSystemEnvProperty(String property) {
        String value = this.getProperty(property);
        if (value == null && (value = System.getProperty(property)) == null) {
            value = System.getenv(property);
        }
        return value;
    }

    public String getSystemEnvProperty(String property, String defaultValue) {
        String value = this.getProperty(property);
        if (value == null && (value = System.getProperty(property)) == null) {
            value = System.getenv(property);
        }
        return value != null ? value : defaultValue;
    }

    public Boolean getBooleanSystemEnvProperty(String property) {
        String value = this.getSystemEnvProperty(property);
        if (value == null) {
            return null;
        }
        if (value.equals("true")) {
            return true;
        }
        return false;
    }

    public boolean getBooleanSystemEnvProperty(String property, boolean defaultValue) {
        String value = this.getSystemEnvProperty(property);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public boolean getBooleanProperty(String property, boolean defaultValue) {
        if (this.allProperties == null) {
            return defaultValue;
        }
        String value = this.allProperties.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public int getIntSystemEnvProperty(String property, int defaultValue) {
        String value = this.getSystemEnvProperty(property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("getIntSystemEnvProperty failed:" + property + "=" + value);
        }
    }

    public Integer getIntSystemEnvProperty(String property) {
        String value = this.getSystemEnvProperty(property);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("getIntSystemEnvProperty failed:" + property + "=" + value);
        }
    }

    public int getIntProperty(String property, int defaultValue) {
        if (this.allProperties == null) {
            return defaultValue;
        }
        String value = this.allProperties.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("getIntProperty failed:" + property + "=" + value);
        }
    }

    public long getLongSystemEnvProperty(String property, long defaultValue) {
        String value = this.getSystemEnvProperty(property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("getLongSystemEnvProperty failed:" + property + "=" + value);
        }
    }

    public Long getLongSystemEnvProperty(String property) {
        String value = this.getSystemEnvProperty(property);
        if (value == null) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("getLongSystemEnvProperty failed:" + property + "=" + value);
        }
    }

    public long getLongProperty(String property, long defaultValue) {
        if (this.allProperties == null) {
            return defaultValue;
        }
        String value = this.allProperties.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("getLongProperty failed:" + property + "=" + value);
        }
    }

    public String getPropertyFromSelf2ndSons(String property) {
        String value = null;
        value = this.sonAndParentProperties == null ? null : this.sonAndParentProperties.getProperty(property);
        if (value == null) {
            value = this.getProperty(property);
        }
        return value;
    }

    public int size() {
        if (this.allProperties == null) {
            return 0;
        }
        return this.allProperties.size();
    }

    public static void main(String[] args) {
        String _configPropertiesFile = "file:/opt/local/xxx.propertis".substring("file:".length());
        System.out.println(_configPropertiesFile);
    }
}

