/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.spring;

import com.baomidou.framework.spring.ScanInfo;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class SpringScanPackage {
    public static Map<String, Set<String>> SCAN_CLASS_MAP = new ConcurrentHashMap<String, Set<String>>();
    private ScanInfo[] scanInfos;

    public void scanPackage() {
        if (null != this.scanInfos && this.scanInfos.length >= 1) {
            for (ScanInfo scanInfo : this.scanInfos) {
                Set<String> clazzSet = SpringScanPackage.findPackageClass(scanInfo.getScanPackages());
                SCAN_CLASS_MAP.put(scanInfo.getScanFlag(), clazzSet);
            }
        }
    }

    public ScanInfo[] getScanInfos() {
        return this.scanInfos;
    }

    public void setScanInfos(ScanInfo[] scanInfos) {
        this.scanInfos = scanInfos;
    }

    public static Set<String> findPackageClass(String scanPackages) {
        HashSet<String> clazzSet = new HashSet<String>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resolver);
        String pkg = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)scanPackages) + "/**/*.class";
        try {
            Resource[] resources = resolver.getResources(pkg);
            if (resources != null && resources.length > 0) {
                for (Resource resource : resources) {
                    MetadataReader metadataReader;
                    if (!resource.isReadable() || (metadataReader = metadataReaderFactory.getMetadataReader(resource)) == null) continue;
                    clazzSet.add(metadataReader.getClassMetadata().getClassName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clazzSet;
    }
}

