/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.spring;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.util.ArrayList;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SWPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final String PROPERTIES_SUFFX = ".properties";

    public void setSwDeployConfigPathKey(String propertiesPath) {
        String configFilePath = System.getProperty(propertiesPath);
        if (configFilePath == null) {
            throw new IllegalArgumentException(propertiesPath + "\u5bf9\u5e94\u7684\u503c\u4e3anull, \u53ef\u80fd\u662fjava.exe\u8fd0\u884c\u65f6, \u6ca1\u6709\u8bbe\u7f6e\u914d\u7f6e\u6587\u4ef6\u7684\u76ee\u5f55-D" + propertiesPath + "=D:/xxx");
        }
        try {
            File file = new File(configFilePath);
            if (!file.exists() || !file.isDirectory()) {
                throw new IllegalArgumentException(propertiesPath + "\u5bf9\u5e94\u7684\u503c\u4e3a" + configFilePath + ", \u5b83\u53ef\u80fd\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55");
            }
            File[] listPropertiesFiles = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(SWPropertyPlaceholderConfigurer.PROPERTIES_SUFFX);
                }
            });
            ArrayList<UrlResource> listResource = null;
            if (listPropertiesFiles != null && listPropertiesFiles.length > 0) {
                listResource = new ArrayList<UrlResource>();
                for (File propertiesFile : listPropertiesFiles) {
                    URI uri = propertiesFile.toURI();
                    UrlResource urlResource = new UrlResource(uri);
                    listResource.add(urlResource);
                }
            }
            if (listResource != null) {
                this.setLocations((Resource[])listResource.toArray(new UrlResource[listResource.size()]));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

