/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.aop;

import com.baomidou.framework.annotations.FormToken;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ResubmitAspect {
    private static final String PARAM_TOKEN = "token";
    private static final String PARAM_TOKEN_FLAG = "TokenFlag_";

    @Around(value="@annotation(formToken)")
    public void execute(ProceedingJoinPoint joinPoint, FormToken formToken) throws Throwable {
        Object[] args = joinPoint.getArgs();
        String className = joinPoint.getTarget().getClass().getName();
        for (Object arg : args) {
            if (arg == null || !(arg instanceof HttpServletRequest)) continue;
            HttpServletRequest request = (HttpServletRequest)arg;
            HttpSession session = request.getSession(true);
            if (formToken == null) continue;
            if ("GET".equalsIgnoreCase(request.getMethod())) {
                this.generate(joinPoint, request, session, PARAM_TOKEN_FLAG + className);
                continue;
            }
            this.validation(joinPoint, request, session, PARAM_TOKEN_FLAG + className);
        }
    }

    public void generate(ProceedingJoinPoint joinPoint, HttpServletRequest request, HttpSession session, String tokenFlag) throws Throwable {
        String uuid = UUID.randomUUID().toString();
        session.setAttribute(tokenFlag, (Object)uuid);
        request.setAttribute(PARAM_TOKEN, (Object)uuid);
        joinPoint.proceed();
    }

    public void validation(ProceedingJoinPoint joinPoint, HttpServletRequest request, HttpSession session, String tokenFlag) throws Throwable {
        Object sessionFlag = session.getAttribute(tokenFlag);
        String requestFlag = request.getParameter(PARAM_TOKEN);
        if (sessionFlag != null && sessionFlag.equals(requestFlag)) {
            session.removeAttribute(tokenFlag);
            joinPoint.proceed();
        }
    }
}

