/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.support;

import com.azure.spring.data.cosmos.core.ReactiveCosmosOperations;
import com.azure.spring.data.cosmos.core.mapping.CosmosMappingContext;
import com.azure.spring.data.cosmos.repository.support.ReactiveCosmosRepositoryFactory;
import java.io.Serializable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class ReactiveCosmosRepositoryFactoryBean<T extends Repository<S, K>, S, K extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, K> {
    private ReactiveCosmosOperations cosmosOperations;
    private boolean mappingContextConfigured = false;

    public ReactiveCosmosRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setReactiveCosmosOperations(ReactiveCosmosOperations operations) {
        this.cosmosOperations = operations;
    }

    protected final RepositoryFactorySupport createRepositoryFactory() {
        return this.getFactoryInstance();
    }

    protected RepositoryFactorySupport getFactoryInstance() {
        return new ReactiveCosmosRepositoryFactory(this.cosmosOperations);
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        this.mappingContextConfigured = true;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (!this.mappingContextConfigured) {
            if (this.cosmosOperations != null) {
                this.setMappingContext(this.cosmosOperations.getConverter().getMappingContext());
            } else {
                this.setMappingContext((MappingContext<?, ?>)new CosmosMappingContext());
            }
        }
    }
}

