/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.query;

import com.azure.spring.data.cosmos.repository.Query;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosEntityMetadata;
import com.azure.spring.data.cosmos.repository.query.SimpleReactiveCosmosEntityMetadata;
import com.azure.spring.data.cosmos.repository.support.CosmosEntityInformation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveCosmosQueryMethod
extends QueryMethod {
    private ReactiveCosmosEntityMetadata<?> metadata;
    private final Method method;
    private final String annotatedQueryValue;

    public ReactiveCosmosQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        super(method, metadata, factory);
        this.method = method;
        this.annotatedQueryValue = this.findAnnotatedQuery(method).orElse(null);
    }

    public EntityMetadata<?> getEntityInformation() {
        Class domainType = this.getDomainClass();
        CosmosEntityInformation entityInformation = new CosmosEntityInformation(domainType);
        this.metadata = new SimpleReactiveCosmosEntityMetadata(domainType, entityInformation);
        return this.metadata;
    }

    public Class<?> getReactiveWrapper() {
        return ReactiveCosmosQueryMethod.isReactiveWrapperClass(this.method.getReturnType()) ? this.method.getReturnType() : null;
    }

    private static boolean isReactiveWrapperClass(Class<?> clazz) {
        return clazz.equals(Flux.class) || clazz.equals(Mono.class);
    }

    public boolean hasAnnotatedQuery() {
        return this.annotatedQueryValue != null;
    }

    @Nullable
    public String getQueryAnnotation() {
        return this.annotatedQueryValue;
    }

    private Optional<String> findAnnotatedQuery(Method method) {
        return Optional.ofNullable((Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Query.class)).map(Query::value).filter(StringUtils::hasText);
    }
}

