/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.config;

import com.azure.spring.data.cosmos.repository.CosmosRepository;
import com.azure.spring.data.cosmos.repository.support.CosmosRepositoryFactoryBean;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;

public class CosmosRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    public String getModuleName() {
        return "cosmos";
    }

    public String getModulePrefix() {
        return "cosmos";
    }

    public String getRepositoryFactoryBeanClassName() {
        return CosmosRepositoryFactoryBean.class.getName();
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(CosmosRepository.class);
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.emptyList();
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource source) {
        AnnotationAttributes attributes = source.getAttributes();
        builder.addPropertyReference("cosmosOperations", attributes.getString("cosmosTemplateRef"));
    }

    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return !metadata.isReactiveRepository();
    }
}

