/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.batch.ItemBatchOperation;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosBatchItemRequestOptions;
import com.azure.cosmos.models.CosmosBatchPatchItemRequestOptions;
import com.azure.cosmos.models.CosmosItemOperation;
import com.azure.cosmos.models.CosmosItemOperationType;
import com.azure.cosmos.models.CosmosPatchOperations;
import com.azure.cosmos.models.PartitionKey;
import java.util.ArrayList;
import java.util.List;

public final class CosmosBatch {
    private final List<ItemBatchOperation<?>> operations;
    private final PartitionKey partitionKey;

    CosmosBatch(PartitionKey partitionKey) {
        Preconditions.checkNotNull(partitionKey, "expected non-null partitionKey");
        this.operations = new ArrayList();
        this.partitionKey = partitionKey;
    }

    public static CosmosBatch createCosmosBatch(PartitionKey partitionKey) {
        return new CosmosBatch(partitionKey);
    }

    public <T> CosmosItemOperation createItemOperation(T item) {
        Preconditions.checkNotNull(item, "expected non-null item");
        return this.createItemOperation(item, new CosmosBatchItemRequestOptions());
    }

    public <T> CosmosItemOperation createItemOperation(T item, CosmosBatchItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, "expected non-null item");
        if (requestOptions == null) {
            requestOptions = new CosmosBatchItemRequestOptions();
        }
        ItemBatchOperation<T> operation = new ItemBatchOperation<T>(CosmosItemOperationType.CREATE, null, this.getPartitionKeyValue(), requestOptions.toRequestOptions(), item);
        this.operations.add(operation);
        return operation;
    }

    public CosmosItemOperation deleteItemOperation(String id) {
        Preconditions.checkNotNull(id, "expected non-null id");
        return this.deleteItemOperation(id, new CosmosBatchItemRequestOptions());
    }

    public CosmosItemOperation deleteItemOperation(String id, CosmosBatchItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        if (requestOptions == null) {
            requestOptions = new CosmosBatchItemRequestOptions();
        }
        ItemBatchOperation<Object> operation = new ItemBatchOperation<Object>(CosmosItemOperationType.DELETE, id, this.getPartitionKeyValue(), requestOptions.toRequestOptions(), null);
        this.operations.add(operation);
        return operation;
    }

    public CosmosItemOperation readItemOperation(String id) {
        Preconditions.checkNotNull(id, "expected non-null id");
        return this.readItemOperation(id, new CosmosBatchItemRequestOptions());
    }

    public CosmosItemOperation readItemOperation(String id, CosmosBatchItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        if (requestOptions == null) {
            requestOptions = new CosmosBatchItemRequestOptions();
        }
        ItemBatchOperation<Object> operation = new ItemBatchOperation<Object>(CosmosItemOperationType.READ, id, this.getPartitionKeyValue(), requestOptions.toRequestOptions(), null);
        this.operations.add(operation);
        return operation;
    }

    public <T> CosmosItemOperation replaceItemOperation(String id, T item) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(item, "expected non-null item");
        return this.replaceItemOperation(id, item, new CosmosBatchItemRequestOptions());
    }

    public <T> CosmosItemOperation replaceItemOperation(String id, T item, CosmosBatchItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(item, "expected non-null item");
        if (requestOptions == null) {
            requestOptions = new CosmosBatchItemRequestOptions();
        }
        ItemBatchOperation<T> operation = new ItemBatchOperation<T>(CosmosItemOperationType.REPLACE, id, this.getPartitionKeyValue(), requestOptions.toRequestOptions(), item);
        this.operations.add(operation);
        return operation;
    }

    public <T> CosmosItemOperation upsertItemOperation(T item) {
        Preconditions.checkNotNull(item, "expected non-null item");
        return this.upsertItemOperation(item, new CosmosBatchItemRequestOptions());
    }

    public <T> CosmosItemOperation upsertItemOperation(T item, CosmosBatchItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(item, "expected non-null item");
        if (requestOptions == null) {
            requestOptions = new CosmosBatchItemRequestOptions();
        }
        ItemBatchOperation<T> operation = new ItemBatchOperation<T>(CosmosItemOperationType.UPSERT, null, this.getPartitionKeyValue(), requestOptions.toRequestOptions(), item);
        this.operations.add(operation);
        return operation;
    }

    public CosmosItemOperation patchItemOperation(String id, CosmosPatchOperations cosmosPatchOperations) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        return this.patchItemOperation(id, cosmosPatchOperations, new CosmosBatchPatchItemRequestOptions());
    }

    public CosmosItemOperation patchItemOperation(String id, CosmosPatchOperations cosmosPatchOperations, CosmosBatchPatchItemRequestOptions requestOptions) {
        Preconditions.checkNotNull(id, "expected non-null id");
        Preconditions.checkNotNull(cosmosPatchOperations, "expected non-null cosmosPatchOperations");
        if (requestOptions == null) {
            requestOptions = new CosmosBatchPatchItemRequestOptions();
        }
        ItemBatchOperation<CosmosPatchOperations> operation = new ItemBatchOperation<CosmosPatchOperations>(CosmosItemOperationType.PATCH, id, this.getPartitionKeyValue(), requestOptions.toRequestOptions(), cosmosPatchOperations);
        this.operations.add(operation);
        return operation;
    }

    public List<CosmosItemOperation> getOperations() {
        return UnmodifiableList.unmodifiableList(this.operations);
    }

    public PartitionKey getPartitionKeyValue() {
        return this.partitionKey;
    }

    List<ItemBatchOperation<?>> getOperationsInternal() {
        return this.operations;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosBatchHelper.setCosmosBatchAccessor(cosmosBatch -> cosmosBatch.getOperationsInternal());
    }

    static {
        CosmosBatch.initialize();
    }
}

