/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query.orderbyquery;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.orderbyquery.ComparisonFilters;

public class ComparisonWithUndefinedFilters
implements ComparisonFilters {
    private final String expression;

    public ComparisonWithUndefinedFilters(String expression) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(expression), "Expression can not be null or empty");
        this.expression = expression;
    }

    @Override
    public String lessThan() {
        return "false";
    }

    @Override
    public String lessThanOrEqualTo() {
        return "NOT IS_DEFINED(" + this.expression + ")";
    }

    @Override
    public String equalTo() {
        return "NOT IS_DEFINED(" + this.expression + ")";
    }

    @Override
    public String greaterThan() {
        return "IS_DEFINED(" + this.expression + ")";
    }

    @Override
    public String greaterThanOrEqualTo() {
        return "true";
    }
}

