/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.implementation.Utils;
import io.netty.channel.ChannelException;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.InterruptedByTimeoutException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import reactor.netty.http.client.PrematureCloseException;

public class WebExceptionUtility {
    public static boolean isWebExceptionRetriable(Exception ex) {
        Exception iterator = ex;
        while (iterator != null) {
            if (WebExceptionUtility.isWebExceptionRetriableInternal(iterator)) {
                return true;
            }
            Throwable t = iterator.getCause();
            iterator = Utils.as(t, Exception.class);
        }
        return false;
    }

    private static boolean isWebExceptionRetriableInternal(Exception ex) {
        IOException webEx = Utils.as(ex, IOException.class);
        if (webEx == null) {
            return false;
        }
        return webEx instanceof ConnectException || webEx instanceof UnknownHostException || webEx instanceof SSLHandshakeException || webEx instanceof NoRouteToHostException || webEx instanceof SSLPeerUnverifiedException;
    }

    public static boolean isNetworkFailure(Exception ex) {
        Exception iterator = ex;
        while (iterator != null) {
            if (WebExceptionUtility.isNetworkFailureInternal(iterator)) {
                return true;
            }
            Throwable t = iterator.getCause();
            iterator = Utils.as(t, Exception.class);
        }
        return false;
    }

    private static boolean isNetworkFailureInternal(Exception ex) {
        if (ex instanceof ClosedChannelException || ex instanceof SocketException || ex instanceof SSLException || ex instanceof UnknownHostException || ex instanceof PrematureCloseException) {
            return true;
        }
        if (ex instanceof UnknownServiceException || ex instanceof HttpRetryException || ex instanceof InterruptedByTimeoutException || ex instanceof InterruptedIOException) {
            return true;
        }
        return ex instanceof ChannelException;
    }

    public static boolean isReadTimeoutException(Exception ex) {
        Exception iterator = ex;
        while (iterator != null) {
            if (WebExceptionUtility.isReadTimeoutExceptionInternal(iterator)) {
                return true;
            }
            Throwable t = iterator.getCause();
            iterator = Utils.as(t, Exception.class);
        }
        return false;
    }

    private static boolean isReadTimeoutExceptionInternal(Exception ex) {
        return ex instanceof ReadTimeoutException;
    }
}

