/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.ISessionToken;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.SessionTokenHelper;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.apachecommons.collections.map.UnmodifiableMap;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.RegionNameToRegionIdMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionScopedRegionLevelProgress {
    private static final Logger logger = LoggerFactory.getLogger(PartitionScopedRegionLevelProgress.class);
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, RegionLevelProgress>> partitionKeyRangeIdToRegionLevelProgress = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> normalizedRegionLookupMap = new ConcurrentHashMap();
    public static final String GLOBAL_PROGRESS_KEY = "global";

    public ConcurrentHashMap<String, ConcurrentHashMap<String, RegionLevelProgress>> getPartitionKeyRangeIdToRegionLevelProgress() {
        return this.partitionKeyRangeIdToRegionLevelProgress;
    }

    public void tryRecordSessionToken(RxDocumentServiceRequest request, ISessionToken parsedSessionToken, String partitionKeyRangeId, String firstEffectivePreferredReadableRegion, String regionRoutedTo) {
        Preconditions.checkNotNull(request, "request cannot be null!");
        Preconditions.checkNotNull(request.requestContext, "requestContext cannot be null!");
        this.partitionKeyRangeIdToRegionLevelProgress.compute(partitionKeyRangeId, (partitionKeyRangeIdAsKey, regionLevelProgressAsVal) -> {
            if (regionLevelProgressAsVal == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding newly encountered partitionKeyRangeId - {}", (Object)partitionKeyRangeId);
                }
                regionLevelProgressAsVal = new ConcurrentHashMap<String, RegionLevelProgress>();
            }
            regionLevelProgressAsVal.merge(GLOBAL_PROGRESS_KEY, new RegionLevelProgress(Long.MIN_VALUE, Long.MIN_VALUE, parsedSessionToken, new AtomicBoolean(false)), (regionLevelProgressExisting, regionLevelProgressNew) -> {
                ISessionToken existingSessionToken = ((RegionLevelProgress)regionLevelProgressExisting).sessionToken;
                ISessionToken newSessionToken = ((RegionLevelProgress)regionLevelProgressNew).sessionToken;
                AtomicBoolean hasPartitionSeenNonPointDocumentOperationsInner = ((RegionLevelProgress)regionLevelProgressExisting).hasPartitionSeenNonPointDocumentOperations;
                return new RegionLevelProgress(Long.MIN_VALUE, Long.MIN_VALUE, existingSessionToken.merge(newSessionToken), hasPartitionSeenNonPointDocumentOperationsInner);
            });
            RegionLevelProgress globalLevelProgress = (RegionLevelProgress)regionLevelProgressAsVal.get(GLOBAL_PROGRESS_KEY);
            Preconditions.checkNotNull(globalLevelProgress, "globalLevelProgress cannot be null!");
            Utils.ValueHolder<UnmodifiableMap<Integer, Long>> localLsnByRegion = new Utils.ValueHolder<UnmodifiableMap<Integer, Long>>();
            if (!SessionTokenHelper.tryEvaluateLocalLsnByRegionMappingWithNullSafety(parsedSessionToken, localLsnByRegion)) {
                request.requestContext.getSessionTokenEvaluationResults().add("Recording only the global session token either because session token doesn't have region id to localLsn mappings or is not a vector session token.");
                return regionLevelProgressAsVal;
            }
            if (request.getResourceType() == ResourceType.Document && !this.isRequestScopedToLogicalPartition(request)) {
                globalLevelProgress.hasPartitionSeenNonPointDocumentOperations.set(true);
            }
            if (globalLevelProgress.hasPartitionSeenNonPointDocumentOperations.get()) {
                request.requestContext.getSessionTokenEvaluationResults().add("Recording only the global session token either because the partition has seen non-point operations.");
                return regionLevelProgressAsVal;
            }
            this.normalizedRegionLookupMap.computeIfAbsent(regionRoutedTo, regionRoutedToAsVal -> regionRoutedToAsVal.toLowerCase(Locale.ROOT).trim().replace(" ", ""));
            String normalizedRegionRoutedTo = this.normalizedRegionLookupMap.get(regionRoutedTo);
            int regionId = RegionNameToRegionIdMap.getRegionId(normalizedRegionRoutedTo);
            if (regionId != -1) {
                long localLsn = ((UnmodifiableMap)localLsnByRegion.v).getOrDefault(regionId, Long.MIN_VALUE);
                if (localLsn != Long.MIN_VALUE) {
                    regionLevelProgressAsVal.compute(normalizedRegionRoutedTo, (normalizedRegionAsKey, regionLevelProgressAsValInner) -> {
                        request.requestContext.getSessionTokenEvaluationResults().add("Recording region specific progress of region : " + normalizedRegionRoutedTo + ".");
                        if (regionLevelProgressAsValInner == null) {
                            return new RegionLevelProgress(parsedSessionToken.getLSN(), localLsn, null, globalLevelProgress.hasPartitionSeenNonPointDocumentOperations);
                        }
                        return new RegionLevelProgress(Math.max(regionLevelProgressAsValInner.getMaxGlobalLsnSeen(), parsedSessionToken.getLSN()), Math.max(regionLevelProgressAsValInner.getMaxLocalLsnSeen(), localLsn), ((RegionLevelProgress)regionLevelProgressAsValInner).sessionToken, globalLevelProgress.hasPartitionSeenNonPointDocumentOperations);
                    });
                } else {
                    regionLevelProgressAsVal.compute(normalizedRegionRoutedTo, (normalizedRegionAsKey, regionLevelProgressAsValInner) -> {
                        request.requestContext.getSessionTokenEvaluationResults().add("Recording region specific progress of region : " + normalizedRegionRoutedTo + ".");
                        if (regionLevelProgressAsValInner == null) {
                            return new RegionLevelProgress(parsedSessionToken.getLSN(), Long.MIN_VALUE, null, globalLevelProgress.hasPartitionSeenNonPointDocumentOperations);
                        }
                        return new RegionLevelProgress(Math.max(regionLevelProgressAsValInner.getMaxGlobalLsnSeen(), parsedSessionToken.getLSN()), Long.MIN_VALUE, ((RegionLevelProgress)regionLevelProgressAsValInner).sessionToken, globalLevelProgress.hasPartitionSeenNonPointDocumentOperations);
                    });
                }
                if (normalizedRegionRoutedTo.equals(firstEffectivePreferredReadableRegion)) {
                    regionLevelProgressAsVal.compute(normalizedRegionRoutedTo, (normalizedRegionAsKey, regionLevelProgressAsValInner) -> {
                        request.requestContext.getSessionTokenEvaluationResults().add("Recording region specific progress of first preferred region : " + regionRoutedTo + ".");
                        if (regionLevelProgressAsValInner == null) {
                            return new RegionLevelProgress(parsedSessionToken.getLSN(), Long.MIN_VALUE, parsedSessionToken, globalLevelProgress.hasPartitionSeenNonPointDocumentOperations);
                        }
                        ISessionToken mergedBasedSessionToken = ((RegionLevelProgress)regionLevelProgressAsValInner).sessionToken == null ? parsedSessionToken : ((RegionLevelProgress)regionLevelProgressAsValInner).sessionToken.merge(parsedSessionToken);
                        return new RegionLevelProgress(Math.max(regionLevelProgressAsValInner.getMaxGlobalLsnSeen(), parsedSessionToken.getLSN()), Long.MIN_VALUE, mergedBasedSessionToken, globalLevelProgress.hasPartitionSeenNonPointDocumentOperations);
                    });
                }
            } else {
                request.requestContext.getSessionTokenEvaluationResults().add("Recording only the global session token since session token provided doesn't have a known region id mapping for region : " + normalizedRegionRoutedTo + ".");
                if (logger.isDebugEnabled()) {
                    logger.debug("Region with name - {} which has no known regionId has been seen", (Object)normalizedRegionRoutedTo);
                }
            }
            return regionLevelProgressAsVal;
        });
    }

    public ISessionToken tryResolveSessionToken(RxDocumentServiceRequest request, Set<String> lesserPreferredRegionsPkProbablyRequestedFrom, String partitionKeyRangeId, String firstEffectivePreferredReadableRegion, boolean canUseRegionScopedSessionTokens) {
        Preconditions.checkNotNull(request, "request cannot be null!");
        Preconditions.checkNotNull(request.requestContext, "requestContext cannot be null!");
        RegionLevelProgress globalLevelProgress = this.resolvePartitionKeyRangeIdBasedProgress(partitionKeyRangeId, GLOBAL_PROGRESS_KEY);
        Preconditions.checkNotNull(globalLevelProgress, "globalLevelProgress cannot be null!");
        ISessionToken globalSessionToken = globalLevelProgress.sessionToken;
        Preconditions.checkNotNull(globalSessionToken, "The session token corresponding to global progress cannot be null!");
        if (!canUseRegionScopedSessionTokens) {
            return globalSessionToken;
        }
        if (globalLevelProgress.hasPartitionSeenNonPointDocumentOperations.get()) {
            request.requestContext.getSessionTokenEvaluationResults().add("Resolving to the global session token since partition has seen non-point requests.");
            return globalSessionToken;
        }
        RegionLevelProgress baseLevelProgress = this.resolvePartitionKeyRangeIdBasedProgress(partitionKeyRangeId, firstEffectivePreferredReadableRegion);
        if (baseLevelProgress == null || baseLevelProgress.sessionToken == null) {
            request.requestContext.getSessionTokenEvaluationResults().add("Resolving to the global session token since session token corresponding to first preferred readable region doesn't exist.");
            return globalSessionToken;
        }
        ISessionToken baseSessionToken = baseLevelProgress.sessionToken;
        if (lesserPreferredRegionsPkProbablyRequestedFrom.isEmpty()) {
            request.requestContext.getSessionTokenEvaluationResults().add("Resolving to the session token corresponding to the first preferred readable region since the requested logical partition has not been resolved to other regions.");
            return baseSessionToken;
        }
        long globalLsn = -1L;
        Utils.ValueHolder<UnmodifiableMap<Integer, Long>> localLsnByRegion = new Utils.ValueHolder<UnmodifiableMap<Integer, Long>>();
        if (!SessionTokenHelper.tryEvaluateLocalLsnByRegionMappingWithNullSafety(globalSessionToken, localLsnByRegion)) {
            request.requestContext.getSessionTokenEvaluationResults().add("Resolving to the global session token either because session token doesn't have region id to localLsn mappings or is not a vector session token.");
            return globalSessionToken;
        }
        Utils.ValueHolder<Long> sessionTokenVersion = new Utils.ValueHolder<Long>();
        if (!SessionTokenHelper.tryEvaluateVersion(globalSessionToken, sessionTokenVersion)) {
            request.requestContext.getSessionTokenEvaluationResults().add("Resolving to the global session token recorded prior because the version cannot be recorded from the global session token.");
            return globalSessionToken;
        }
        StringBuilder sbPartOne = new StringBuilder();
        StringBuilder sbPartTwo = new StringBuilder();
        for (Map.Entry localLsnByRegionEntry : ((UnmodifiableMap)localLsnByRegion.v).entrySet()) {
            int regionId = (Integer)localLsnByRegionEntry.getKey();
            String normalizedRegionName = RegionNameToRegionIdMap.getRegionName(regionId);
            if (normalizedRegionName.equals("")) {
                if (logger.isDebugEnabled()) {
                    logger.debug("regionId with value - {} which has no known region name has been seen in the vector session token", (Object)regionId);
                }
                request.requestContext.getSessionTokenEvaluationResults().add("Resolving to the global session token since session token provided doesn't have a known region name mapping for region id : " + regionId + ".");
                return globalSessionToken;
            }
            if (lesserPreferredRegionsPkProbablyRequestedFrom.contains(normalizedRegionName)) {
                request.requestContext.getSessionTokenEvaluationResults().add("Resolving region specific progress from " + normalizedRegionName);
                RegionLevelProgress satelliteRegionProgress = this.resolvePartitionKeyRangeIdBasedProgress(partitionKeyRangeId, normalizedRegionName);
                globalLsn = Math.max(globalLsn, satelliteRegionProgress.maxGlobalLsnSeen);
                sbPartTwo.append('#');
                sbPartTwo.append(regionId);
                sbPartTwo.append('=');
                sbPartTwo.append(satelliteRegionProgress.maxLocalLsnSeen);
                continue;
            }
            request.requestContext.getSessionTokenEvaluationResults().add("No region specific progress to resolve from " + normalizedRegionName);
            sbPartTwo.append('#');
            sbPartTwo.append(regionId);
            sbPartTwo.append('=');
            sbPartTwo.append(-1);
        }
        sbPartOne.append(sessionTokenVersion.v);
        sbPartOne.append('#');
        sbPartOne.append(globalLsn);
        Utils.ValueHolder<Object> resolvedSessionToken = new Utils.ValueHolder<Object>(null);
        if (SessionTokenHelper.tryParse(sbPartOne.append((CharSequence)sbPartTwo).toString(), resolvedSessionToken)) {
            return baseSessionToken.merge((ISessionToken)resolvedSessionToken.v);
        }
        request.requestContext.getSessionTokenEvaluationResults().add("Resolving to the global session token since session token from the first preferred region couldn't be merged with region-resolved session token : " + ((ISessionToken)resolvedSessionToken.v).convertToString() + ".");
        return globalSessionToken;
    }

    public boolean isPartitionKeyRangeIdPresent(String partitionKeyRangeId) {
        return this.partitionKeyRangeIdToRegionLevelProgress.containsKey(partitionKeyRangeId);
    }

    private RegionLevelProgress resolvePartitionKeyRangeIdBasedProgress(String partitionKeyRangeId, String progressScope) {
        ConcurrentHashMap<String, RegionLevelProgress> regionToRegionLevelProgress = this.partitionKeyRangeIdToRegionLevelProgress.get(partitionKeyRangeId);
        Preconditions.checkNotNull(regionToRegionLevelProgress, "regionToRegionLevelProgress cannot be null!");
        return regionToRegionLevelProgress.get(progressScope);
    }

    private boolean isRequestScopedToLogicalPartition(RxDocumentServiceRequest request) {
        return request.getPartitionKeyInternal() != null;
    }

    public boolean getHasPartitionSeenNonPointRequestsForDocuments(String partitionKeyRangeId) {
        if (this.partitionKeyRangeIdToRegionLevelProgress.containsKey(partitionKeyRangeId)) {
            ConcurrentHashMap<String, RegionLevelProgress> regionToRegionLevelProgress = this.partitionKeyRangeIdToRegionLevelProgress.get(partitionKeyRangeId);
            RegionLevelProgress regionLevelProgress = regionToRegionLevelProgress.get(GLOBAL_PROGRESS_KEY);
            if (regionLevelProgress == null) {
                return false;
            }
            return regionLevelProgress.hasPartitionSeenNonPointDocumentOperations.get();
        }
        return false;
    }

    static class RegionLevelProgress {
        private final long maxGlobalLsnSeen;
        private final long maxLocalLsnSeen;
        private final ISessionToken sessionToken;
        private final AtomicBoolean hasPartitionSeenNonPointDocumentOperations;

        public RegionLevelProgress(long maxGlobalLsnSeen, long maxLocalLsnSeen, ISessionToken sessionToken, AtomicBoolean hasPartitionSeenNonPointDocumentOperations) {
            this.maxGlobalLsnSeen = maxGlobalLsnSeen;
            this.maxLocalLsnSeen = maxLocalLsnSeen;
            this.sessionToken = sessionToken;
            this.hasPartitionSeenNonPointDocumentOperations = hasPartitionSeenNonPointDocumentOperations;
        }

        public long getMaxGlobalLsnSeen() {
            return this.maxGlobalLsnSeen;
        }

        public long getMaxLocalLsnSeen() {
            return this.maxLocalLsnSeen;
        }

        public ISessionToken getSessionToken() {
            return this.sessionToken;
        }

        public void setHasPartitionSeenNonPointDocumentOperations(boolean hasPartitionSeenNonPointDocumentOperations) {
            this.hasPartitionSeenNonPointDocumentOperations.set(hasPartitionSeenNonPointDocumentOperations);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegionLevelProgress that = (RegionLevelProgress)o;
            return this.maxGlobalLsnSeen == that.maxGlobalLsnSeen && this.maxLocalLsnSeen == that.maxLocalLsnSeen && Objects.equals(this.sessionToken, that.sessionToken) && this.hasPartitionSeenNonPointDocumentOperations.get() == that.hasPartitionSeenNonPointDocumentOperations.get();
        }

        public int hashCode() {
            return Objects.hash(this.maxGlobalLsnSeen, this.maxLocalLsnSeen, this.sessionToken, this.hasPartitionSeenNonPointDocumentOperations);
        }
    }
}

